/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;

public final class Utils3D {
    static final float GRID_MIN = -10.0f;
    static final float GRID_MAX = 10.0f;
    static final float GRID_STEP = 1.0f;
    private static Model axesModel;
    private static ModelInstance axesInstance;
    private static Model floorModel;
    private static ModelInstance floorInstance;

    public static void dispose() {
        if (axesModel != null) {
            axesModel.dispose();
        }
        axesModel = null;
        if (floorModel != null) {
            floorModel.dispose();
        }
        floorModel = null;
    }

    public static void createFloor() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        MeshPartBuilder mpb = modelBuilder.part("parts", 4, 11L, new Material(new Attribute[]{ColorAttribute.createDiffuse((Color)Color.WHITE)}));
        mpb.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        mpb.rect(-10.0f, 0.0f, -10.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, 10.0f, 10.0f, 0.0f, -10.0f, 0.0f, 1.0f, 0.0f);
        floorModel = modelBuilder.end();
        floorInstance = new ModelInstance(floorModel);
        ((Material)Utils3D.floorInstance.materials.get(0)).set((Attribute)new BlendingAttribute(770, 771));
    }

    private static void createAxes() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        MeshPartBuilder builder = modelBuilder.part("grid", 1, 3L, new Material());
        builder.setColor(Color.LIGHT_GRAY);
        for (float t = -10.0f; t <= 10.0f; t += 1.0f) {
            builder.line(t, 0.0f, -10.0f, t, 0.0f, 10.0f);
            builder.line(-10.0f, 0.0f, t, 10.0f, 0.0f, t);
        }
        builder = modelBuilder.part("axes", 1, 3L, new Material());
        builder.setColor(Color.RED);
        builder.line(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
        builder.setColor(Color.GREEN);
        builder.line(0.0f, 0.0f, 0.0f, 0.0f, 10.0f, 0.0f);
        builder.setColor(Color.BLUE);
        builder.line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 10.0f);
        axesModel = modelBuilder.end();
        axesInstance = new ModelInstance(axesModel);
    }

    public static ModelInstance getFloor() {
        if (floorModel == null) {
            Utils3D.createFloor();
        }
        return floorInstance;
    }

    public static ModelInstance getAxes() {
        if (axesModel == null) {
            Utils3D.createAxes();
        }
        return axesInstance;
    }
}

