/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.provider;

import com.bstek.uflo.console.provider.ProcessFile;
import com.bstek.uflo.console.provider.ProcessProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class DefaultFileProcessProvider
implements ProcessProvider,
ApplicationContextAware,
InitializingBean {
    public String prefix = "file:";
    private ApplicationContext applicationContext;
    private String fileStoreDir;
    private boolean disabled;

    @Override
    public InputStream loadProcess(String file) {
        if (file.startsWith(this.prefix)) {
            file = file.substring(this.prefix.length(), file.length());
        }
        String fullPath = this.fileStoreDir + "/" + file;
        try {
            return new FileInputStream(fullPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveProcess(String file, String content) {
        if (file.startsWith(this.prefix)) {
            file = file.substring(this.prefix.length(), file.length());
        }
        String fullPath = this.fileStoreDir + "/" + file;
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(new File(fullPath));
            IOUtils.write((String)content, (OutputStream)outStream, (String)"utf-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void deleteProcess(String file) {
        String fullPath;
        File f;
        if (file.startsWith(this.prefix)) {
            file = file.substring(this.prefix.length(), file.length());
        }
        if ((f = new File(fullPath = this.fileStoreDir + "/" + file)).exists()) {
            f.delete();
        }
    }

    @Override
    public List<ProcessFile> loadAllProcesses() {
        File file = new File(this.fileStoreDir);
        ArrayList<ProcessFile> list = new ArrayList<ProcessFile>();
        for (File f : file.listFiles()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(f.lastModified());
            list.add(new ProcessFile(f.getName(), calendar.getTime()));
        }
        Collections.sort(list, new Comparator<ProcessFile>(){

            @Override
            public int compare(ProcessFile f1, ProcessFile f2) {
                return f2.getUpdateDate().compareTo(f1.getUpdateDate());
            }
        });
        return list;
    }

    public void afterPropertiesSet() throws Exception {
        File file = new File(this.fileStoreDir);
        if (file.exists()) {
            return;
        }
        WebApplicationContext context = (WebApplicationContext)this.applicationContext;
        ServletContext servletContext = context.getServletContext();
        String basePath = servletContext.getRealPath("/");
        this.fileStoreDir = basePath + this.fileStoreDir;
        file = new File(this.fileStoreDir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFileStoreDir(String fileStoreDir) {
        this.fileStoreDir = fileStoreDir;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean support(String fileName) {
        return fileName.startsWith(this.prefix);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return "\u9ed8\u8ba4\u6587\u4ef6\u7cfb\u7edf";
    }
}

