/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.list;

import com.bstek.uflo.console.handler.impl.WriteJsonServletHandler;
import com.bstek.uflo.console.handler.impl.list.AssigneeInfo;
import com.bstek.uflo.process.assign.Assignee;
import com.bstek.uflo.process.assign.AssigneeProvider;
import com.bstek.uflo.process.assign.Entity;
import com.bstek.uflo.process.assign.PageQuery;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AssigneeProviderListServletHandler
extends WriteJsonServletHandler
implements ApplicationContextAware {
    Map<String, AssigneeProvider> assigneeProviderMaps = new HashMap<String, AssigneeProvider>();
    private boolean debug;

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String parentId;
        String pageSize;
        String loginUser = EnvironmentUtils.getEnvironment().getLoginUser();
        if (loginUser == null && !this.debug) {
            throw new IllegalArgumentException("Current run mode is not debug.");
        }
        request.setCharacterEncoding("utf-8");
        String pageIndex = request.getParameter("pageIndex");
        if (StringUtils.isEmpty((String)pageIndex)) {
            pageIndex = "1";
        }
        if (StringUtils.isEmpty((String)(pageSize = request.getParameter("pageSize")))) {
            pageSize = "1000";
        }
        if ((parentId = request.getParameter("parentId")) != null && parentId.equals("null")) {
            parentId = null;
        }
        String providerId = request.getParameter("providerId");
        PageQuery pageQuery = new PageQuery(Integer.valueOf(pageIndex).intValue(), Integer.valueOf(pageSize).intValue());
        if (StringUtils.isNotEmpty((String)providerId)) {
            AssigneeInfo info = this.buildAssigneeInfo(parentId, (PageQuery<Entity>)pageQuery, providerId, true);
            this.writeObjectToJson(response, info);
        } else {
            ArrayList<AssigneeInfo> result = new ArrayList<AssigneeInfo>();
            for (String beanId : this.assigneeProviderMaps.keySet()) {
                AssigneeInfo info = this.buildAssigneeInfo(parentId, (PageQuery<Entity>)pageQuery, beanId, false);
                result.add(info);
            }
            this.writeObjectToJson(response, result);
        }
    }

    private AssigneeInfo buildAssigneeInfo(String parentId, PageQuery<Entity> pageQuery, String beanId, boolean buildEntity) {
        AssigneeProvider provider = this.assigneeProviderMaps.get(beanId);
        provider.queryEntities(pageQuery, parentId);
        AssigneeInfo info = new AssigneeInfo();
        info.setName(provider.getName());
        info.setTree(provider.isTree());
        info.setProviderId(beanId);
        if (buildEntity) {
            ArrayList<Assignee> assignees = new ArrayList<Assignee>();
            Collection entitys = pageQuery.getResult();
            if (entitys != null) {
                for (Entity entity : entitys) {
                    Assignee assignee = new Assignee();
                    assignee.setId(entity.getId());
                    assignee.setName(entity.getName());
                    assignee.setProviderId(beanId);
                    assignee.setChosen(entity.isChosen());
                    assignees.add(assignee);
                }
            }
            info.setAssignees(assignees);
            info.setCount(pageQuery.getRecordCount());
        }
        return info;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(AssigneeProvider.class);
        for (String beanId : map.keySet()) {
            AssigneeProvider provider = (AssigneeProvider)map.get(beanId);
            if (provider.disable()) continue;
            this.assigneeProviderMaps.put(beanId, provider);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public String url() {
        return "/assignproviderlist";
    }
}

