/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.diagram;

import com.bstek.uflo.console.handler.impl.RenderPageServletHandler;
import com.bstek.uflo.diagram.NodeDiagram;
import com.bstek.uflo.diagram.ProcessDiagram;
import com.bstek.uflo.diagram.SequenceFlowDiagram;
import com.bstek.uflo.diagram.TaskDiagramInfoProvider;
import com.bstek.uflo.diagram.TaskInfo;
import com.bstek.uflo.model.HistoryActivity;
import com.bstek.uflo.model.HistoryProcessInstance;
import com.bstek.uflo.model.HistoryTask;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.query.HistoryTaskQuery;
import com.bstek.uflo.query.TaskQuery;
import com.bstek.uflo.service.HistoryService;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.TaskService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ProcessDiagramServletHandler
extends RenderPageServletHandler {
    private boolean showTime;
    private String passedNodeBgcolor;
    private String passedNodeFontColor;
    private int passedNodeFontSize;
    private String passedNodeBorderColor;
    private String passedConnectionColor;
    private String passedConnectionFontColor;
    private int passedConnectionFontSize;
    private String multiCurrentNodeBgcolor;
    private String multiCurrentNodeFontColor;
    private int multiCurrentNodeFontSize;
    private String multiCurrentNodeBorderColor;
    private String connectionColor;
    private String connectionFontColor;
    private int connectionFontSize;
    private String nodeBgcolor;
    private String nodeFontColor;
    private int nodeFontSize;
    private String nodeBorderColor;
    private String currentNodeBgcolor;
    private String currentNodeFontColor;
    private int currentNodeFontSize;
    private String currentNodeBorderColor;
    private ProcessService processService;
    private TaskService taskService;
    private HistoryService historyService;
    private List<TaskDiagramInfoProvider> providers;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            String taskId = req.getParameter("taskId");
            String processKey = req.getParameter("processKey");
            String processInstanceId = req.getParameter("processInstanceId");
            String processId = req.getParameter("processId");
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            if (StringUtils.isNotBlank((String)taskId)) {
                sb.append("taskId:" + taskId);
            }
            if (StringUtils.isNotBlank((String)processKey)) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append("processKey:'" + processKey + "'");
            }
            if (StringUtils.isNotBlank((String)processInstanceId)) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append("processInstanceId:" + processInstanceId + "");
            }
            if (StringUtils.isNotBlank((String)processId)) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append("processId:" + processId + "");
            }
            sb.append("}");
            if (sb.length() < 5) {
                throw new ServletException("Show process diagram need one parameter:taskId or processKey or processInstanceId or processId");
            }
            context.put("parameters", (Object)sb.toString());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("uflo-html/diagram.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadDiagramData(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ProcessDiagram diagram = null;
        String processKey = req.getParameter("processKey");
        Long taskId = ProcessDiagramServletHandler.parseLong(req.getParameter("taskId"));
        Long processInstanceId = ProcessDiagramServletHandler.parseLong(req.getParameter("processInstanceId"));
        Long processId = ProcessDiagramServletHandler.parseLong(req.getParameter("processId"));
        if (taskId != null) {
            Task task = this.taskService.getTask(taskId.longValue());
            if (task == null) {
                HistoryTask historyTask = this.historyService.getHistoryTask(taskId.longValue());
                if (historyTask == null) throw new IllegalArgumentException("Task " + taskId + " is not exist!");
                processInstanceId = historyTask.getProcessInstanceId();
                diagram = this.buildDiagramByProcessId(historyTask.getProcessId());
                try {
                    diagram = (ProcessDiagram)diagram.clone();
                    this.resetProcessDiagramDefaultStyle(diagram);
                }
                catch (CloneNotSupportedException e) {
                    throw new ServletException((Throwable)e);
                }
                this.rebuildProcessDiagram(diagram, processInstanceId);
            } else {
                processInstanceId = task.getProcessInstanceId();
                diagram = this.buildDiagramByTaskId(task);
            }
        } else if (processInstanceId != null) {
            diagram = this.buildDiagramByProcessInstanceId(processInstanceId);
        } else if (processId != null) {
            diagram = this.buildDiagramByProcessId(processId);
        } else if (StringUtils.isNotEmpty((String)processKey)) {
            diagram = this.buildDiagramByProcessKey(processKey);
        }
        if (diagram == null) {
            throw new IllegalArgumentException("There is not enough information to load process diagram!");
        }
        if (processInstanceId != null && processInstanceId != 0L) {
            ProcessInstance pi = this.processService.getProcessInstanceById(Long.valueOf(processInstanceId).longValue());
            HistoryProcessInstance hpi = null;
            if (pi == null) {
                hpi = this.historyService.getHistoryProcessInstance(processInstanceId.longValue());
            }
            Long rootProcessInstanceId = null;
            if (pi != null) {
                rootProcessInstanceId = pi.getRootId();
            } else {
                if (hpi == null) throw new IllegalArgumentException("ProcessInstance [" + processInstanceId + "] not exist.");
                rootProcessInstanceId = hpi.getProcessInstanceId();
            }
            ProcessDefinition pd = null;
            if (pi != null) {
                pd = this.processService.getProcessById(pi.getProcessId());
            }
            if (hpi != null) {
                pd = this.processService.getProcessById(hpi.getProcessId());
            }
            List<HistoryTask> historyTasks = this.queryHistoryTasks(rootProcessInstanceId);
            List nodeDiagrams = diagram.getNodeDiagrams();
            for (NodeDiagram nodeDiagram : nodeDiagrams) {
                Node node = pd.getNode(nodeDiagram.getName());
                if (!(node instanceof TaskNode) && !(node instanceof StartNode)) continue;
                TaskQuery query = this.taskService.createTaskQuery();
                query.rootProcessInstanceId(rootProcessInstanceId.longValue());
                query.nodeName(node.getName());
                query.addTaskState(TaskState.Created);
                query.addTaskState(TaskState.InProgress);
                query.addTaskState(TaskState.Ready);
                query.addTaskState(TaskState.Suspended);
                query.addTaskState(TaskState.Reserved);
                List tasks = (List)query.list();
                StringBuffer sb = null;
                for (TaskDiagramInfoProvider provider : this.providers) {
                    List<HistoryTask> hisTasks;
                    String info = null;
                    ArrayList<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();
                    if (tasks.size() > 0) {
                        taskInfoList.addAll(this.buildTaskInfos(tasks));
                    }
                    if ((hisTasks = this.filterHistoryTasks(historyTasks, node.getName())).size() > 0) {
                        taskInfoList.addAll(this.buildHistoryTaskInfos(hisTasks));
                    }
                    if (!StringUtils.isNotEmpty((String)(info = provider.getInfo(node.getName(), taskInfoList)))) continue;
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    sb.append(info);
                }
                if (sb == null) continue;
                nodeDiagram.setInfo(sb.toString());
            }
        }
        diagram.setShowTime(this.showTime);
        this.writeObjectToJson(res, diagram);
    }

    private List<HistoryTask> filterHistoryTasks(List<HistoryTask> historyTasks, String nodeName) {
        ArrayList<HistoryTask> result = new ArrayList<HistoryTask>();
        for (HistoryTask hisTask : historyTasks) {
            if (!hisTask.getNodeName().equals(nodeName)) continue;
            result.add(hisTask);
        }
        return result;
    }

    private List<HistoryTask> queryHistoryTasks(long rootProcessInstanceId) {
        HistoryTaskQuery historyTaskQuery = this.historyService.createHistoryTaskQuery();
        historyTaskQuery.rootProcessInstanceId(rootProcessInstanceId);
        List historyTasks = (List)historyTaskQuery.list();
        return historyTasks;
    }

    private List<TaskInfo> buildTaskInfos(List<Task> tasks) {
        ArrayList<TaskInfo> infos = new ArrayList<TaskInfo>();
        for (Task task : tasks) {
            TaskInfo info = new TaskInfo();
            info.setAssignee(task.getAssignee());
            info.setBusinessId(task.getBusinessId());
            info.setCreateDate(task.getCreateDate());
            info.setDescription(task.getDescription());
            info.setDuedate(task.getDuedate());
            info.setOpinion(task.getOpinion());
            info.setOwner(task.getOwner());
            info.setProcessId(task.getProcessId());
            info.setProcessInstanceId(task.getProcessInstanceId());
            info.setState(task.getState());
            info.setTaskId(task.getId());
            info.setTaskName(task.getTaskName());
            info.setTaskId(task.getId());
            info.setType(task.getType());
            info.setUrl(task.getUrl());
            infos.add(info);
        }
        return infos;
    }

    private List<TaskInfo> buildHistoryTaskInfos(List<HistoryTask> tasks) {
        ArrayList<TaskInfo> infos = new ArrayList<TaskInfo>();
        for (HistoryTask task : tasks) {
            TaskInfo info = new TaskInfo();
            info.setAssignee(task.getAssignee());
            info.setBusinessId(task.getBusinessId());
            info.setCreateDate(task.getCreateDate());
            info.setDescription(task.getDescription());
            info.setDuedate(task.getDuedate());
            info.setEndDate(task.getEndDate());
            info.setOpinion(task.getOpinion());
            info.setOwner(task.getOwner());
            info.setProcessId(task.getProcessId());
            info.setProcessInstanceId(task.getProcessInstanceId());
            info.setState(task.getState());
            info.setTaskId(task.getId());
            info.setTaskName(task.getTaskName());
            info.setTaskId(task.getId());
            info.setType(task.getType());
            info.setUrl(task.getUrl());
            infos.add(info);
        }
        return infos;
    }

    private ProcessDiagram buildDiagramByTaskId(Task task) {
        ProcessInstance pi = this.processService.getProcessInstanceById(task.getProcessInstanceId());
        ProcessDefinition pd = this.processService.getProcessById(task.getProcessId());
        ProcessDiagram diagram = pd.getDiagram();
        try {
            diagram = (ProcessDiagram)diagram.clone();
            this.resetProcessDiagramDefaultStyle(diagram);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.rebuildProcessDiagram(diagram, pi.getRootId());
        for (NodeDiagram nodeDiagram : diagram.getNodeDiagrams()) {
            if (!nodeDiagram.getName().equals(task.getNodeName())) continue;
            nodeDiagram.setBackgroundColor(this.multiCurrentNodeBgcolor);
            nodeDiagram.setBorderColor(this.multiCurrentNodeBorderColor);
            nodeDiagram.setFontColor(this.multiCurrentNodeFontColor);
            nodeDiagram.setFontSize(this.multiCurrentNodeFontSize);
            nodeDiagram.setFontBold(true);
            break;
        }
        return diagram;
    }

    private ProcessDiagram buildDiagramByProcessInstanceId(Long processInstanceId) {
        ProcessInstance pi = this.processService.getProcessInstanceById(processInstanceId.longValue());
        long processId = 0L;
        long rootId = 0L;
        if (pi != null) {
            processId = pi.getProcessId();
            rootId = pi.getRootId();
        } else {
            HistoryProcessInstance hpi = this.historyService.getHistoryProcessInstance(processInstanceId.longValue());
            if (hpi != null) {
                processId = hpi.getProcessId();
                rootId = hpi.getProcessInstanceId();
            } else {
                throw new IllegalArgumentException("ProcessInstance " + processInstanceId + " is not exist!");
            }
        }
        ProcessDefinition pd = this.processService.getProcessById(processId);
        ProcessDiagram diagram = pd.getDiagram();
        try {
            diagram = (ProcessDiagram)diagram.clone();
            this.resetProcessDiagramDefaultStyle(diagram);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.rebuildProcessDiagram(diagram, rootId);
        return diagram;
    }

    private ProcessDiagram buildDiagramByProcessId(Long processId) {
        ProcessDefinition pd = this.processService.getProcessById(processId.longValue());
        ProcessDiagram diagram = pd.getDiagram();
        this.resetProcessDiagramDefaultStyle(diagram);
        return diagram;
    }

    private ProcessDiagram buildDiagramByProcessKey(String processKey) {
        ProcessDefinition pd = this.processService.getProcessByKey(processKey);
        ProcessDiagram diagram = pd.getDiagram();
        this.resetProcessDiagramDefaultStyle(diagram);
        return diagram;
    }

    private void rebuildProcessDiagram(ProcessDiagram diagram, long processInstanceId) {
        String nodeName;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashMap<String, HistoryActivity> map = new HashMap<String, HistoryActivity>();
        List activities = this.historyService.getHistoryActivitysByProcesssInstanceId(processInstanceId);
        for (HistoryActivity hisActivity : activities) {
            nodeName = hisActivity.getNodeName();
            if (countMap.containsKey(nodeName)) {
                int count = (Integer)countMap.get(nodeName);
                countMap.put(nodeName, ++count);
                continue;
            }
            countMap.put(nodeName, 1);
        }
        for (NodeDiagram d : diagram.getNodeDiagrams()) {
            nodeName = d.getName();
            HistoryActivity activity = this.getHistoryActivity(activities, nodeName);
            if (activity == null) continue;
            map.put(nodeName, activity);
            if (countMap.containsKey(nodeName)) {
                int count = (Integer)countMap.get(nodeName);
                d.setTime(count);
            }
            String icon = d.getIcon();
            String resultIcon = null;
            if (activity.getEndDate() == null) {
                resultIcon = icon.substring(0, icon.lastIndexOf("/")) + "/current" + icon.substring(icon.lastIndexOf("/"));
                d.setFontColor(this.currentNodeFontColor);
                d.setBackgroundColor(this.currentNodeBgcolor);
                d.setBorderColor(this.currentNodeBorderColor);
                d.setFontColor(this.currentNodeFontColor);
                d.setFontSize(this.currentNodeFontSize);
            } else {
                resultIcon = icon.substring(0, icon.lastIndexOf("/")) + "/passed" + icon.substring(icon.lastIndexOf("/"));
                d.setFontColor(this.passedNodeFontColor);
                d.setBorderColor(this.passedNodeBorderColor);
                d.setBackgroundColor(this.passedNodeBgcolor);
                d.setFontSize(this.passedNodeFontSize);
            }
            d.setIcon(resultIcon);
        }
        for (NodeDiagram d : diagram.getNodeDiagrams()) {
            String sourceName = d.getName();
            HistoryActivity source = (HistoryActivity)map.get(sourceName);
            if (source == null || d.getSequenceFlowDiagrams() == null) continue;
            for (SequenceFlowDiagram flowDiagram : d.getSequenceFlowDiagrams()) {
                HistoryActivity target = (HistoryActivity)map.get(flowDiagram.getTo());
                if (target == null) continue;
                flowDiagram.setBorderColor(this.passedConnectionColor);
                flowDiagram.setFontColor(this.passedConnectionFontColor);
                flowDiagram.setFontSize(this.passedConnectionFontSize);
            }
        }
    }

    private void resetProcessDiagramDefaultStyle(ProcessDiagram diagram) {
        for (NodeDiagram d : diagram.getNodeDiagrams()) {
            d.setBackgroundColor(this.nodeBgcolor);
            d.setBorderColor(this.nodeBorderColor);
            d.setFontColor(this.nodeFontColor);
            d.setFontSize(this.nodeFontSize);
            List list = d.getSequenceFlowDiagrams();
            if (list == null) continue;
            for (SequenceFlowDiagram flow : list) {
                flow.setBorderColor(this.connectionColor);
                flow.setFontColor(this.connectionFontColor);
                flow.setFontSize(this.connectionFontSize);
            }
        }
    }

    private HistoryActivity getHistoryActivity(List<HistoryActivity> activities, String nodeName) {
        ArrayList<HistoryActivity> result = new ArrayList<HistoryActivity>();
        for (HistoryActivity activity : activities) {
            if (!activity.getNodeName().equals(nodeName)) continue;
            result.add(activity);
        }
        HistoryActivity target = null;
        for (HistoryActivity ac : result) {
            if (ac.getEndDate() != null) continue;
            target = ac;
            break;
        }
        if (target == null && result.size() > 0) {
            return (HistoryActivity)result.get(0);
        }
        return target;
    }

    public void afterPropertiesSet() throws Exception {
        this.providers = new ArrayList<TaskDiagramInfoProvider>();
        Collection parentProviders = this.applicationContext.getBeansOfType(TaskDiagramInfoProvider.class).values();
        for (TaskDiagramInfoProvider provider : parentProviders) {
            if (provider.disable()) continue;
            this.providers.add(provider);
        }
    }

    private static Long parseLong(Object obj) {
        Long val;
        if (obj == null) {
            val = null;
        } else if (obj instanceof Number) {
            val = ((Number)obj).longValue();
        } else {
            try {
                val = Long.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                val = null;
            }
        }
        return val;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public void setPassedNodeBgcolor(String passedNodeBgcolor) {
        this.passedNodeBgcolor = passedNodeBgcolor;
    }

    public void setPassedNodeFontColor(String passedNodeFontColor) {
        this.passedNodeFontColor = passedNodeFontColor;
    }

    public void setPassedNodeFontSize(int passedNodeFontSize) {
        this.passedNodeFontSize = passedNodeFontSize;
    }

    public void setPassedNodeBorderColor(String passedNodeBorderColor) {
        this.passedNodeBorderColor = passedNodeBorderColor;
    }

    public void setPassedConnectionColor(String passedConnectionColor) {
        this.passedConnectionColor = passedConnectionColor;
    }

    public void setPassedConnectionFontColor(String passedConnectionFontColor) {
        this.passedConnectionFontColor = passedConnectionFontColor;
    }

    public void setConnectionColor(String connectionColor) {
        this.connectionColor = connectionColor;
    }

    public void setConnectionFontColor(String connectionFontColor) {
        this.connectionFontColor = connectionFontColor;
    }

    public void setNodeBgcolor(String nodeBgcolor) {
        this.nodeBgcolor = nodeBgcolor;
    }

    public void setNodeFontColor(String nodeFontColor) {
        this.nodeFontColor = nodeFontColor;
    }

    public void setNodeFontSize(int nodeFontSize) {
        this.nodeFontSize = nodeFontSize;
    }

    public void setNodeBorderColor(String nodeBorderColor) {
        this.nodeBorderColor = nodeBorderColor;
    }

    public void setCurrentNodeBgcolor(String currentNodeBgcolor) {
        this.currentNodeBgcolor = currentNodeBgcolor;
    }

    public void setCurrentNodeFontColor(String currentNodeFontColor) {
        this.currentNodeFontColor = currentNodeFontColor;
    }

    public void setCurrentNodeFontSize(int currentNodeFontSize) {
        this.currentNodeFontSize = currentNodeFontSize;
    }

    public void setCurrentNodeBorderColor(String currentNodeBorderColor) {
        this.currentNodeBorderColor = currentNodeBorderColor;
    }

    public void setConnectionFontSize(int connectionFontSize) {
        this.connectionFontSize = connectionFontSize;
    }

    public void setPassedConnectionFontSize(int passedConnectionFontSize) {
        this.passedConnectionFontSize = passedConnectionFontSize;
    }

    public void setMultiCurrentNodeBgcolor(String multiCurrentNodeBgcolor) {
        this.multiCurrentNodeBgcolor = multiCurrentNodeBgcolor;
    }

    public void setMultiCurrentNodeBorderColor(String multiCurrentNodeBorderColor) {
        this.multiCurrentNodeBorderColor = multiCurrentNodeBorderColor;
    }

    public void setMultiCurrentNodeFontColor(String multiCurrentNodeFontColor) {
        this.multiCurrentNodeFontColor = multiCurrentNodeFontColor;
    }

    public void setMultiCurrentNodeFontSize(int multiCurrentNodeFontSize) {
        this.multiCurrentNodeFontSize = multiCurrentNodeFontSize;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        Collection coll = applicationContext.getBeansOfType(TaskDiagramInfoProvider.class).values();
        this.providers = new ArrayList<TaskDiagramInfoProvider>();
        for (TaskDiagramInfoProvider p : coll) {
            if (p.disable()) continue;
            this.providers.add(p);
        }
    }

    @Override
    public String url() {
        return "/diagram";
    }
}

