/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.channel.ChannelUtil;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.impl.SmppSessionChannelListener;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.BindReceiver;
import com.cloudhopper.smpp.pdu.BindTransceiver;
import com.cloudhopper.smpp.pdu.BindTransmitter;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.pdu.EnquireLinkResp;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.LoggingOptions;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppProcessingException;
import java.util.TimerTask;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundSmppSession
implements SmppSessionChannelListener {
    private static final Logger logger = LoggerFactory.getLogger(UnboundSmppSession.class);
    private final String channelName;
    private final Channel channel;
    private final BindTimeoutTask bindTimeoutTask;
    private final DefaultSmppServer server;

    public UnboundSmppSession(String channelName, Channel channel, DefaultSmppServer server) {
        this.channelName = channelName;
        this.channel = channel;
        this.server = server;
        this.bindTimeoutTask = new BindTimeoutTask();
        this.server.getBindTimer().schedule((TimerTask)this.bindTimeoutTask, this.server.getConfiguration().getBindTimeout());
    }

    @Override
    public void firePduReceived(Pdu pdu) {
        logger.info("received PDU: {}", (Object)pdu);
        if (pdu instanceof BaseBind) {
            BaseBind bindRequest = (BaseBind)pdu;
            SmppSessionConfiguration sessionConfiguration = this.createSessionConfiguration(bindRequest);
            Long sessionId = this.server.nextSessionId();
            try {
                this.server.bindRequested(sessionId, sessionConfiguration, bindRequest);
            }
            catch (SmppProcessingException e) {
                logger.warn("Bind request rejected or failed for connection [{}] with error [{}]", (Object)this.channelName, (Object)e.getMessage());
                BaseBindResp bindResponse = this.server.createBindResponse(bindRequest, e.getErrorCode());
                this.sendResponsePdu(bindResponse);
                this.closeChannelAndCancelTimer();
                return;
            }
            this.bindTimeoutTask.cancel();
            BaseBindResp preparedBindResponse = this.server.createBindResponse(bindRequest, 0);
            try {
                this.server.createSession(sessionId, this.channel, sessionConfiguration, preparedBindResponse);
            }
            catch (SmppProcessingException e) {
                logger.warn("Bind request was approved, but createSession failed for connection [{}] with error [{}]", (Object)this.channelName, (Object)e.getMessage());
                BaseBindResp bindResponse = this.server.createBindResponse(bindRequest, e.getErrorCode());
                this.sendResponsePdu(bindResponse);
                this.closeChannelAndCancelTimer();
                return;
            }
        }
        if (pdu instanceof EnquireLink) {
            EnquireLinkResp response = ((EnquireLink)pdu).createResponse();
            logger.info("Responding to enquire_link with response [{}]", (Object)response);
            this.sendResponsePdu(response);
            return;
        }
        logger.warn("Only bind or enquire_link requests are permitted on new connections, closing connection [{}]", (Object)this.channelName);
        this.closeChannelAndCancelTimer();
        return;
    }

    public void closeChannelAndCancelTimer() {
        this.bindTimeoutTask.cancel();
        this.channel.close();
    }

    @Override
    public void fireExceptionThrown(Throwable t) {
        logger.warn("Exception thrown, closing connection [{}]: {}", (Object)this.channelName, (Object)t);
        this.closeChannelAndCancelTimer();
    }

    @Override
    public void fireChannelClosed() {
        logger.info("Connection closed with [{}]", (Object)this.channelName);
        this.closeChannelAndCancelTimer();
    }

    protected SmppSessionConfiguration createSessionConfiguration(BaseBind bindRequest) {
        SmppSessionConfiguration sessionConfiguration = new SmppSessionConfiguration();
        sessionConfiguration.setName("SmppServerSession." + bindRequest.getSystemId() + "." + bindRequest.getSystemType());
        sessionConfiguration.setSystemId(bindRequest.getSystemId());
        sessionConfiguration.setPassword(bindRequest.getPassword());
        sessionConfiguration.setSystemType(bindRequest.getSystemType());
        sessionConfiguration.setBindTimeout(this.server.getConfiguration().getBindTimeout());
        sessionConfiguration.setAddressRange(bindRequest.getAddressRange());
        sessionConfiguration.setHost(ChannelUtil.getChannelRemoteHost(this.channel));
        sessionConfiguration.setPort(ChannelUtil.getChannelRemotePort(this.channel));
        sessionConfiguration.setInterfaceVersion(bindRequest.getInterfaceVersion());
        LoggingOptions loggingOptions = new LoggingOptions();
        loggingOptions.setLogPdu(true);
        sessionConfiguration.setLoggingOptions(loggingOptions);
        if (bindRequest instanceof BindTransceiver) {
            sessionConfiguration.setType(SmppBindType.TRANSCEIVER);
        } else if (bindRequest instanceof BindReceiver) {
            sessionConfiguration.setType(SmppBindType.RECEIVER);
        } else if (bindRequest instanceof BindTransmitter) {
            sessionConfiguration.setType(SmppBindType.TRANSMITTER);
        }
        sessionConfiguration.setWindowSize(this.server.getConfiguration().getDefaultWindowSize());
        sessionConfiguration.setWindowWaitTimeout(this.server.getConfiguration().getDefaultWindowWaitTimeout());
        sessionConfiguration.setWindowMonitorInterval(this.server.getConfiguration().getDefaultWindowMonitorInterval());
        sessionConfiguration.setRequestExpiryTimeout(this.server.getConfiguration().getDefaultRequestExpiryTimeout());
        sessionConfiguration.setCountersEnabled(this.server.getConfiguration().isDefaultSessionCountersEnabled());
        return sessionConfiguration;
    }

    public void sendResponsePdu(PduResponse pdu) {
        try {
            ChannelBuffer buffer = this.server.getTranscoder().encode(pdu);
            logger.info("send PDU: {}", (Object)pdu);
            ChannelFuture channelFuture = this.channel.write((Object)buffer).await();
            if (!channelFuture.isSuccess()) {
                throw new SmppChannelException(channelFuture.getCause().getMessage(), channelFuture.getCause());
            }
        }
        catch (Exception e) {
            logger.error("Fatal exception thrown while attempting to send response PDU: {}", (Throwable)e);
        }
    }

    private final class BindTimeoutTask
    extends TimerTask {
        private BindTimeoutTask() {
        }

        @Override
        public void run() {
            logger.warn("Channel not bound within [{}] ms, closing connection [{}]", (Object)UnboundSmppSession.this.server.getConfiguration().getBindTimeout(), (Object)UnboundSmppSession.this.channelName);
            UnboundSmppSession.this.channel.close();
            this.cancel();
            UnboundSmppSession.this.server.getCounters().incrementBindTimeoutsAndGet();
        }
    }
}

