/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class SlidingWindowReservoir
implements Reservoir {
    private final AtomicLong index = new AtomicLong();
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray measurements;

    public SlidingWindowReservoir(int size) {
        this.measurements = new AtomicLongArray(size);
    }

    @Override
    public int size() {
        return (int)Math.min(this.count.get(), (long)this.measurements.length());
    }

    @Override
    public void update(long value) {
        int n = (int)(this.index.getAndIncrement() % (long)this.measurements.length());
        this.measurements.set(n, value);
        this.count.incrementAndGet();
    }

    @Override
    public Snapshot getSnapshot() {
        long[] values = new long[this.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.measurements.get(i);
        }
        return new Snapshot(values);
    }
}

