/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.saml;

import com.coveo.saml.BrowserUtils;
import com.coveo.saml.SamlException;
import com.coveo.saml.SamlResponse;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.validator.ResponseSchemaValidator;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.DOMMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SamlClient {
    private static final Logger logger = LoggerFactory.getLogger(SamlClient.class);
    private static boolean initializedOpenSaml = false;
    private String relyingPartyIdentifier;
    private String assertionConsumerServiceUrl;
    private String identityProviderUrl;
    private String responseIssuer;
    private List<Credential> credentials;
    private DateTime now;
    private SamlIdpBinding samlBinding;

    public String getIdentityProviderUrl() {
        return this.identityProviderUrl;
    }

    public void setDateTimeNow(DateTime now) {
        this.now = now;
    }

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, List<java.security.cert.X509Certificate> certificates, SamlIdpBinding samlBinding) throws SamlException {
        SamlClient.ensureOpenSamlIsInitialized();
        if (relyingPartyIdentifier == null) {
            throw new IllegalArgumentException("relyingPartyIdentifier");
        }
        if (identityProviderUrl == null) {
            throw new IllegalArgumentException("identityProviderUrl");
        }
        if (responseIssuer == null) {
            throw new IllegalArgumentException("responseIssuer");
        }
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("certificates");
        }
        this.relyingPartyIdentifier = relyingPartyIdentifier;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.identityProviderUrl = identityProviderUrl;
        this.responseIssuer = responseIssuer;
        this.credentials = certificates.stream().map(SamlClient::getCredential).collect(Collectors.toList());
        this.samlBinding = samlBinding;
    }

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, List<java.security.cert.X509Certificate> certificates) throws SamlException {
        this(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, certificates, SamlIdpBinding.POST);
    }

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, java.security.cert.X509Certificate certificate) throws SamlException {
        this(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, Collections.singletonList(certificate), SamlIdpBinding.POST);
    }

    public String getSamlRequest() throws SamlException {
        AuthnRequest request = (AuthnRequest)SamlClient.buildSamlObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        request.setID("z" + UUID.randomUUID().toString());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(DateTime.now());
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-" + this.samlBinding.toString());
        request.setAssertionConsumerServiceURL(this.assertionConsumerServiceUrl);
        Issuer issuer = (Issuer)SamlClient.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.relyingPartyIdentifier);
        request.setIssuer(issuer);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)SamlClient.buildSamlObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        request.setNameIDPolicy(nameIDPolicy);
        StringWriter stringWriter = new StringWriter();
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)request);
            Element dom = marshaller.marshall((XMLObject)request);
            XMLHelper.writeNode((Node)dom, (Writer)stringWriter);
        }
        catch (MarshallingException ex) {
            throw new SamlException("Error while marshalling SAML request to XML", ex);
        }
        logger.trace("Issuing SAML request: " + stringWriter.toString());
        try {
            return Base64.encodeBytes((byte[])stringWriter.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new SamlException("Error while encoding SAML request", ex);
        }
    }

    public SamlResponse decodeAndValidateSamlResponse(String encodedResponse) throws SamlException {
        Response response;
        String decodedResponse;
        try {
            decodedResponse = new String(Base64.decode((String)encodedResponse), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SamlException("Cannot decode base64 encoded response", ex);
        }
        logger.trace("Validating SAML response: " + decodedResponse);
        try {
            DOMParser parser = SamlClient.createDOMParser();
            parser.parse(new InputSource(new StringReader(decodedResponse)));
            response = (Response)Configuration.getUnmarshallerFactory().getUnmarshaller(parser.getDocument().getDocumentElement()).unmarshall(parser.getDocument().getDocumentElement());
        }
        catch (IOException | UnmarshallingException | SAXException ex) {
            throw new SamlException("Cannot decode xml encoded response", ex);
        }
        this.validateResponse(response);
        this.validateAssertion(response);
        this.validateSignature(response);
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        return new SamlResponse(assertion);
    }

    public void redirectToIdentityProvider(HttpServletResponse response, String relayState) throws IOException, SamlException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("SAMLRequest", this.getSamlRequest());
        if (relayState != null) {
            values.put("RelayState", relayState);
        }
        BrowserUtils.postUsingBrowser(this.identityProviderUrl, response, values);
    }

    public SamlResponse processPostFromIdentityProvider(HttpServletRequest request) throws SamlException {
        String encodedResponse = request.getParameter("SAMLResponse");
        return this.decodeAndValidateSamlResponse(encodedResponse);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata) throws SamlException {
        return SamlClient.fromMetadata(relyingPartyIdentifier, assertionConsumerServiceUrl, metadata, SamlIdpBinding.POST);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata, SamlIdpBinding samlBinding) throws SamlException {
        return SamlClient.fromMetadata(relyingPartyIdentifier, assertionConsumerServiceUrl, metadata, samlBinding, null);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata, SamlIdpBinding samlBinding, List<java.security.cert.X509Certificate> certificates) throws SamlException {
        SamlClient.ensureOpenSamlIsInitialized();
        MetadataProvider metadataProvider = SamlClient.createMetadataProvider(metadata);
        EntityDescriptor entityDescriptor = SamlClient.getEntityDescriptor(metadataProvider);
        IDPSSODescriptor idpSsoDescriptor = SamlClient.getIDPSSODescriptor(entityDescriptor);
        SingleSignOnService idpBinding = SamlClient.getIdpBinding(idpSsoDescriptor, samlBinding);
        List<java.security.cert.X509Certificate> x509Certificates = SamlClient.getCertificates(idpSsoDescriptor);
        boolean isOkta = entityDescriptor.getEntityID().contains(".okta.com");
        if (relyingPartyIdentifier == null) {
            if (isOkta) {
                relyingPartyIdentifier = entityDescriptor.getEntityID();
            } else {
                throw new IllegalArgumentException("relyingPartyIdentifier");
            }
        }
        if (assertionConsumerServiceUrl == null && isOkta) {
            assertionConsumerServiceUrl = idpBinding.getLocation();
        }
        if (certificates != null) {
            x509Certificates.addAll(certificates);
        }
        String identityProviderUrl = idpBinding.getLocation();
        String responseIssuer = entityDescriptor.getEntityID();
        return new SamlClient(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, x509Certificates, samlBinding);
    }

    private void validateResponse(Response response) throws SamlException {
        try {
            new ResponseSchemaValidator().validate(response);
        }
        catch (ValidationException ex) {
            throw new SamlException("The response schema validation failed", ex);
        }
        if (!response.getIssuer().getValue().equals(this.responseIssuer)) {
            throw new SamlException("The response issuer didn't match the expected value");
        }
        String statusCode = response.getStatus().getStatusCode().getValue();
        if (!statusCode.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            throw new SamlException("Invalid status code: " + statusCode);
        }
    }

    private void validateAssertion(Response response) throws SamlException {
        if (response.getAssertions().size() != 1) {
            throw new SamlException("The response doesn't contain exactly 1 assertion");
        }
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        if (!assertion.getIssuer().getValue().equals(this.responseIssuer)) {
            throw new SamlException("The assertion issuer didn't match the expected value");
        }
        if (assertion.getSubject().getNameID() == null) {
            throw new SamlException("The NameID value is missing from the SAML response; this is likely an IDP configuration issue");
        }
        this.enforceConditions(assertion.getConditions());
    }

    private void enforceConditions(Conditions conditions) throws SamlException {
        DateTime now;
        DateTime dateTime = now = this.now != null ? this.now : DateTime.now();
        if (now.isBefore((ReadableInstant)conditions.getNotBefore())) {
            throw new SamlException("The assertion cannot be used before " + conditions.getNotBefore().toString());
        }
        if (now.isAfter((ReadableInstant)conditions.getNotOnOrAfter())) {
            throw new SamlException("The assertion cannot be used after  " + conditions.getNotOnOrAfter().toString());
        }
    }

    private void validateSignature(Response response) throws SamlException {
        Signature responseSignature = response.getSignature();
        Signature assertionSignature = ((Assertion)response.getAssertions().get(0)).getSignature();
        if (responseSignature == null && assertionSignature == null) {
            throw new SamlException("No signature is present in either response or assertion");
        }
        if (responseSignature != null && !this.validate(responseSignature)) {
            throw new SamlException("The response signature is invalid");
        }
        if (assertionSignature != null && !this.validate(assertionSignature)) {
            throw new SamlException("The assertion signature is invalid");
        }
    }

    private boolean validate(Signature signature) {
        if (signature == null) {
            return false;
        }
        return this.credentials.stream().anyMatch(c -> {
            try {
                SignatureValidator signatureValidator = new SignatureValidator(c);
                signatureValidator.validate(signature);
                return true;
            }
            catch (ValidationException ex) {
                return false;
            }
        });
    }

    private static synchronized void ensureOpenSamlIsInitialized() throws SamlException {
        if (!initializedOpenSaml) {
            try {
                DefaultBootstrap.bootstrap();
                initializedOpenSaml = true;
            }
            catch (Throwable ex) {
                throw new SamlException("Error while initializing the Open SAML library", ex);
            }
        }
    }

    private static DOMParser createDOMParser() throws SamlException {
        DOMParser parser = new DOMParser(){
            {
                try {
                    this.setFeature("http://apache.org/xml/features/include-comments", false);
                }
                catch (Throwable ex) {
                    throw new SamlException("Cannot disable comments parsing to mitigate https://www.kb.cert.org/vuls/id/475445", ex);
                }
            }
        };
        return parser;
    }

    private static MetadataProvider createMetadataProvider(Reader metadata) throws SamlException {
        try {
            DOMParser parser = SamlClient.createDOMParser();
            parser.parse(new InputSource(metadata));
            DOMMetadataProvider provider = new DOMMetadataProvider(parser.getDocument().getDocumentElement());
            provider.initialize();
            return provider;
        }
        catch (IOException | MetadataProviderException | SAXException ex) {
            throw new SamlException("Cannot load identity provider metadata", ex);
        }
    }

    private static EntityDescriptor getEntityDescriptor(MetadataProvider metadataProvider) throws SamlException {
        EntityDescriptor descriptor;
        try {
            descriptor = (EntityDescriptor)metadataProvider.getMetadata();
        }
        catch (MetadataProviderException ex) {
            throw new SamlException("Cannot retrieve the entity descriptor", ex);
        }
        if (descriptor == null) {
            throw new SamlException("Cannot retrieve the entity descriptor");
        }
        return descriptor;
    }

    private static IDPSSODescriptor getIDPSSODescriptor(EntityDescriptor entityDescriptor) throws SamlException {
        IDPSSODescriptor idpssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new SamlException("Cannot retrieve IDP SSO descriptor");
        }
        return idpssoDescriptor;
    }

    private static SingleSignOnService getIdpBinding(IDPSSODescriptor idpSsoDescriptor, SamlIdpBinding samlBinding) throws SamlException {
        return idpSsoDescriptor.getSingleSignOnServices().stream().filter(x -> x.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-" + samlBinding.toString())).findAny().orElseThrow(() -> new SamlException("Cannot find HTTP-POST SSO binding in metadata"));
    }

    private static List<java.security.cert.X509Certificate> getCertificates(IDPSSODescriptor idpSsoDescriptor) throws SamlException {
        List<java.security.cert.X509Certificate> certificates;
        try {
            certificates = idpSsoDescriptor.getKeyDescriptors().stream().filter(x -> x.getUse() == UsageType.SIGNING).flatMap(SamlClient::getDatasWithCertificates).map(SamlClient::getFirstCertificate).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SamlException("Exception in getCertificates", e);
        }
        return certificates;
    }

    private static Stream<X509Data> getDatasWithCertificates(KeyDescriptor descriptor) {
        return descriptor.getKeyInfo().getX509Datas().stream().filter(d -> d.getX509Certificates().size() > 0);
    }

    private static java.security.cert.X509Certificate getFirstCertificate(X509Data data) {
        try {
            X509Certificate cert = data.getX509Certificates().stream().findFirst().orElse(null);
            if (cert != null) {
                return KeyInfoHelper.getCertificate((X509Certificate)cert);
            }
        }
        catch (CertificateException e) {
            logger.error("Exception in getFirstCertificate", (Throwable)e);
        }
        return null;
    }

    private static Credential getCredential(java.security.cert.X509Certificate certificate) {
        BasicX509Credential credential = new BasicX509Credential();
        credential.setEntityCertificate(certificate);
        credential.setPublicKey(certificate.getPublicKey());
        credential.setCRLs(Collections.emptyList());
        return credential;
    }

    private static XMLObject buildSamlObject(QName qname) {
        return Configuration.getBuilderFactory().getBuilder(qname).buildObject(qname);
    }

    public static enum SamlIdpBinding {
        POST,
        Redirect;

    }
}

