/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit;

import com.cybermkd.mongo.kit.MongoBean;
import com.cybermkd.mongo.kit.MongoKit;
import com.cybermkd.mongo.kit.geospatial.MongoGeospatial;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class MongoDocumentKit {
    public static Document toDocument(Object obj) {
        if (Document.class.isInstance(obj)) {
            return (Document)obj;
        }
        Map<String, Object> map = !Map.class.isInstance(obj) ? MongoKit.INSTANCE.toMap(obj) : (Map<String, Object>)obj;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof MongoGeospatial) {
                map.put(entry.getKey(), ((MongoGeospatial)entry.getValue()).getPoint());
            }
            if (entry.getValue() instanceof MongoBean) {
                Document doc = MongoDocumentKit.toDocument((MongoBean)entry.getValue());
                map.put(entry.getKey(), doc);
            }
            if (!(entry.getValue() instanceof List)) continue;
            try {
                List list = (List)entry.getValue();
                ArrayList<Document> docList = new ArrayList<Document>();
                for (int i = 0; i < list.size(); ++i) {
                    Document doc = MongoDocumentKit.toDocument((MongoBean)list.get(i));
                    docList.add(doc);
                }
                map.put(entry.getKey(), docList);
            }
            catch (RuntimeException e) {
                MongoKit.INSTANCE.error("MongoDocumentKit.class", "The list must be List<MongoBean> inserted into the database.");
            }
        }
        String id = (String)map.get("id");
        if (id == null || id.equals("")) {
            map.remove("id");
        }
        return new Document(map);
    }

    public static Document toDocument(MongoBean bean) {
        return new Document(bean.toMap());
    }

    public static boolean conversionValidation(Object obj) {
        if (String.class.isInstance(obj) || Integer.class.isInstance(obj) || Double.class.isInstance(obj) || Boolean.class.isInstance(obj) || Float.class.isInstance(obj) || Character.class.isInstance(obj) || Long.class.isInstance(obj) || Byte.class.isInstance(obj) || Short.class.isInstance(obj) || Date.class.isInstance(obj) || Map.class.isInstance(obj)) {
            return false;
        }
        return obj instanceof Object;
    }
}

