/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit;

import ch.qos.logback.classic.Level;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.Block;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MongoKit {
    INSTANCE;

    private static MongoClient client;
    private static MongoDatabase defaultDb;
    private static Logger logger;

    public MongoClient getClient() {
        return client;
    }

    public void init(MongoClient client, String database) {
        MongoKit.client = client;
        defaultDb = client.getDatabase(database);
    }

    public MongoCollection<Document> getCollection(String collectionName) {
        return defaultDb.getCollection(collectionName);
    }

    public void insert(String collectionName, List<Document> docs, InsertManyOptions ops) {
        this.getCollection(collectionName).insertMany(this.uniding(docs), ops);
    }

    public void insert(String collectionName, Document doc) {
        this.getCollection(collectionName).insertOne((Object)this.uniding(doc));
    }

    public List<JSONObject> aggregate(String collectionName, List<Bson> query, boolean allowDiskUse) {
        final ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Block<Document> block = new Block<Document>(){

            public void apply(Document document) {
                document = MongoKit.this.iding(document);
                list.add(MongoKit.this.parseObject(document.toJson()));
            }
        };
        this.getCollection(collectionName).aggregate(query).allowDiskUse(Boolean.valueOf(allowDiskUse)).forEach((Block)block);
        return list;
    }

    public <T> List<T> aggregate(String collectionName, List<Bson> query, boolean allowDiskUse, final Class<T> clazz) {
        final ArrayList list = new ArrayList();
        Block<Document> block = new Block<Document>(){

            public void apply(Document document) {
                document = MongoKit.this.iding(document);
                list.add(MongoKit.this.parseObject(document, clazz));
            }
        };
        this.getCollection(collectionName).aggregate(query).allowDiskUse(Boolean.valueOf(allowDiskUse)).forEach((Block)block);
        return list;
    }

    public List<JSONObject> find(String collectionName, Bson projection) {
        return this.find(collectionName, (Bson)new BsonDocument(), (Bson)new BsonDocument(), projection, 0, 0, "");
    }

    public List<JSONObject> find(String collectionName, int limit, Bson sort, Bson projection) {
        return this.find(collectionName, (Bson)new BsonDocument(), sort, projection, limit, 0, "");
    }

    public List<JSONObject> find(String collectionName, int limit, int skip, Bson sort, Bson projection, String join) {
        return this.find(collectionName, (Bson)new BsonDocument(), sort, projection, limit, skip, join);
    }

    public <T> List<T> find(String collectionName, int limit, Bson sort, Bson projection, Class<T> clazz) {
        return this.find(collectionName, (Bson)new BsonDocument(), sort, projection, limit, 0, "", clazz);
    }

    public <T> List<T> find(String collectionName, int limit, int skip, Bson sort, Bson projection, String join, Class<T> clazz) {
        return this.find(collectionName, (Bson)new BsonDocument(), sort, projection, limit, skip, join, clazz);
    }

    public List<JSONObject> find(String collectionName, Bson query, Bson projection) {
        return this.find(collectionName, query, (Bson)new BsonDocument(), projection, 0, 0, "");
    }

    public long count(String collectionName, Bson query) {
        return this.getCollection(collectionName).count(query);
    }

    public long count(String collectionName) {
        return this.getCollection(collectionName).count();
    }

    public JSONObject findOne(String collectionName, Bson query, Bson sort, String join) {
        return this.toJSON(this.iding(this.jointing((Document)this.getCollection(collectionName).find(query).sort(sort).first(), join)));
    }

    public <T> T findOne(String collectionName, Bson query, Bson sort, String join, Class<T> clazz) {
        return this.parseObject(this.iding(this.jointing((Document)this.getCollection(collectionName).find(query).sort(sort).first(), join)), clazz);
    }

    public List<JSONObject> find(String collectionName, Bson query, Bson sort, Bson projection, int limit, int skip, final String join) {
        final ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Block<Document> block = new Block<Document>(){

            public void apply(Document document) {
                document = MongoKit.this.iding(document);
                document = MongoKit.this.jointing(document, join);
                list.add(MongoKit.this.toJSON(document));
            }
        };
        this.getCollection(collectionName).find(query).projection(projection).sort(sort).limit(limit).skip(skip).forEach((Block)block);
        return list;
    }

    public <T> List<T> find(String collectionName, Bson query, Bson sort, Bson projection, int limit, int skip, final String join, final Class<T> clazz) {
        final ArrayList list = new ArrayList();
        Block<Document> block = new Block<Document>(){

            public void apply(Document document) {
                document = MongoKit.this.iding(document);
                document = MongoKit.this.jointing(document, join);
                list.add(MongoKit.this.parseObject(document, clazz));
            }
        };
        this.getCollection(collectionName).find(query).projection(projection).sort(sort).limit(limit).skip(skip).forEach((Block)block);
        return list;
    }

    public long update(String collectionName, Bson queue, Bson data) {
        UpdateResult updateResult = this.getCollection(collectionName).updateMany(queue, data);
        return updateResult.getModifiedCount();
    }

    public long updateOne(String collectionName, Bson queue, Bson data) {
        UpdateResult updateResult = this.getCollection(collectionName).updateOne(queue, data);
        return updateResult.getModifiedCount();
    }

    public long replaceOne(String collectionName, Bson queue, Document document) {
        UpdateResult updateResult = this.getCollection(collectionName).replaceOne(queue, (Object)document);
        return updateResult.getModifiedCount();
    }

    public long delete(String collectionName, Bson queue) {
        DeleteResult deleteResult = this.getCollection(collectionName).deleteMany(queue);
        return deleteResult.getDeletedCount();
    }

    public long deleteOne(String collectionName, Bson queue) {
        DeleteResult deleteResult = this.getCollection(collectionName).deleteOne(queue);
        return deleteResult.getDeletedCount();
    }

    public String validation(Object obj) {
        StringBuffer buffer = new StringBuffer(64);
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set constraintViolations = validator.validate(obj, new Class[0]);
        for (ConstraintViolation c : constraintViolations) {
            buffer.append(c.getMessage());
        }
        return buffer.toString();
    }

    public String validation(Object obj, String[] keys) {
        StringBuffer buffer = new StringBuffer(64);
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        HashSet constraintViolations = new HashSet();
        for (String key : keys) {
            Iterator it = validator.validateProperty(obj, key, new Class[0]).iterator();
            if (!it.hasNext()) continue;
            constraintViolations.add(it.next());
        }
        for (ConstraintViolation c : constraintViolations) {
            buffer.append(c.getMessage());
        }
        return buffer.toString();
    }

    public String setIndex(String collectionName, Bson bson) {
        return this.getCollection(collectionName).createIndex(bson);
    }

    public List<String> setIndex(String collectionName, List<IndexModel> list) {
        return this.getCollection(collectionName).createIndexes(list);
    }

    public List<JSONObject> getIndex(String collectionName) {
        final ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Block<Document> block = new Block<Document>(){

            public void apply(Document document) {
                list.add(MongoKit.this.parseObject(document.toJson()));
            }
        };
        this.getCollection(collectionName).listIndexes().forEach((Block)block);
        return list;
    }

    public void deleteIndex(String collectionName, Bson bson) {
        this.getCollection(collectionName).dropIndex(bson);
    }

    public void deleteIndex(String collectionName) {
        this.getCollection(collectionName).dropIndexes();
    }

    private Document iding(Document document) {
        try {
            if (document == null || document.get((Object)"_id") == null) {
                return document;
            }
            document.put("_id", (Object)document.get((Object)"_id").toString());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return document;
    }

    private List<Document> uniding(List<Document> list) {
        ArrayList<Document> newList = new ArrayList<Document>();
        for (Document doc : list) {
            newList.add(this.uniding(doc));
        }
        return newList;
    }

    private Document uniding(Document document) {
        try {
            if (document == null || document.get((Object)"_id") == null) {
                return document;
            }
            document.remove((Object)"_id");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return document;
    }

    private Document jointing(Document document, String join) {
        if (join != null && !join.isEmpty()) {
            try {
                DBRef dbRef = (DBRef)document.get((Object)join, DBRef.class);
                Document joinDoc = (Document)this.getCollection(dbRef.getCollectionName()).find((Bson)new Document("_id", dbRef.getId())).first();
                joinDoc = this.iding(joinDoc);
                joinDoc.put("id", (Object)joinDoc.getString((Object)"_id"));
                joinDoc.remove((Object)"_id");
                document.put(join, (Object)joinDoc);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return document;
    }

    private JSONObject parseObject(String json) {
        try {
            if (json != null && !json.isEmpty()) {
                return JSON.parseObject((String)json);
            }
            return new JSONObject();
        }
        catch (NullPointerException e) {
            this.error("parseObject", json);
            return new JSONObject();
        }
    }

    private <T> T parseObject(Document doc, Class<T> clazz) {
        try {
            if (doc == null) {
                return (T)JSON.parseObject((String)new JSONObject().toJSONString(), clazz);
            }
            return (T)JSON.parseObject((String)JSON.toJSONString((Object)doc), clazz);
        }
        catch (NullPointerException e) {
            this.error("parseObject", clazz.getName());
            return (T)JSON.parseObject((String)new JSONObject().toJSONString(), clazz);
        }
    }

    private JSONObject toJSON(Object obj) {
        try {
            return (JSONObject)JSON.toJSON((Object)obj);
        }
        catch (NullPointerException e) {
            this.error("toJSON", obj.getClass().getName());
            return new JSONObject();
        }
    }

    protected void error(String funName, String text) {
        logger.error("MongKit tips: (\u3065\uffe3 3\uffe3)\u3065 " + funName + " is error ! " + text);
    }

    public Map<String, Object> toMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            INSTANCE.error("MongKit.class", "toMap is error " + e.getMessage());
        }
        return map;
    }

    public void setDebug(boolean debug) {
        Level level = debug ? Level.DEBUG : Level.WARN;
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(level);
    }

    static {
        logger = LoggerFactory.getLogger((String)MongoKit.class.getName());
    }
}

