/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit;

import com.alibaba.fastjson.JSONObject;
import com.cybermkd.mongo.kit.MongoDocumentKit;
import com.cybermkd.mongo.kit.MongoKit;
import com.cybermkd.mongo.kit.geospatial.MongoGeospatial;
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.TextSearchOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Position;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongoQuery {
    private String collectionName;
    private String join;
    private Document document = new Document();
    private List<Document> documents = new ArrayList<Document>();
    private List<Bson> query = new ArrayList<Bson>();
    private List<Bson> data = new ArrayList<Bson>();
    private Bson sort;
    private Bson projection;
    private String id;
    private int limit = 0;
    private int skip = 0;

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public Bson getSort() {
        return this.sort;
    }

    public MongoQuery use(String name) {
        this.collectionName = name;
        return this;
    }

    public static Bson and(List<Bson> q) {
        return q.size() == 0 ? new BsonDocument() : Filters.and(q);
    }

    public MongoQuery or(MongoQuery ... qs) {
        this.orQuery(Arrays.asList(qs));
        return this;
    }

    public MongoQuery orQuery(List<MongoQuery> qs) {
        ArrayList<Bson> bsons = new ArrayList<Bson>();
        for (MongoQuery q : qs) {
            bsons.add(MongoQuery.and(q.getQuery()));
        }
        this.query.add(MongoQuery.or(bsons));
        return this;
    }

    public static Bson or(List<Bson> q) {
        return q.size() == 0 ? new BsonDocument() : Filters.or(q);
    }

    public static Bson or(Bson q) {
        return Filters.or((Bson[])new Bson[]{q});
    }

    public MongoQuery nor(MongoQuery q) {
        this.query.add(MongoQuery.nor(q.getQuery()));
        return this;
    }

    public static Bson nor(List<Bson> query) {
        return query.size() == 0 ? new BsonDocument() : Filters.nor(query);
    }

    public MongoQuery join(String key, String collectionName, String id) {
        DBRef ref = new DBRef(collectionName, (Object)new ObjectId(id));
        this.document.append(key, (Object)ref);
        return this;
    }

    public MongoQuery join(String key) {
        this.join = key;
        return this;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public List<Bson> getQuery() {
        return this.query;
    }

    public String getId() {
        return this.id;
    }

    public List<Bson> data() {
        return this.data;
    }

    public MongoQuery set(String key, Object value) {
        if (MongoDocumentKit.conversionValidation(value)) {
            this.document.append(key, (Object)MongoDocumentKit.toDocument(value));
        } else {
            this.document.append(key, value);
        }
        return this;
    }

    public MongoQuery setGeo(String key, Double x, Double y) {
        this.document.append(key, (Object)new Point(new Position(x.doubleValue(), y.doubleValue(), new double[0])));
        return this;
    }

    public MongoQuery set(Object obj) {
        this.document = MongoDocumentKit.toDocument(obj);
        return this;
    }

    public MongoQuery add(MongoQuery query) {
        this.documents.add(query.getDocument());
        return this;
    }

    public MongoQuery add(Bson bson) {
        this.data.add(bson);
        return this;
    }

    public MongoQuery filter(Bson filter) {
        this.query.add(filter);
        return this;
    }

    public MongoQuery eq(String key, Object value) {
        this.query.add(Filters.eq((String)key, (Object)value));
        return this;
    }

    public MongoQuery ne(String key, Object value) {
        this.query.add(Filters.ne((String)key, (Object)value));
        return this;
    }

    public MongoQuery regex(String key, String regex) {
        this.query.add(Filters.regex((String)key, (String)regex));
        return this;
    }

    public MongoQuery type(String key, String type) {
        this.query.add(Filters.type((String)key, (String)type));
        return this;
    }

    public MongoQuery mod(String key, long divisor, long remainder) {
        this.query.add(Filters.mod((String)key, (long)divisor, (long)remainder));
        return this;
    }

    public MongoQuery text(String search) {
        this.query.add(Filters.text((String)search));
        return this;
    }

    public MongoQuery text(String search, TextSearchOptions textSearchOptions) {
        this.query.add(Filters.text((String)search, (TextSearchOptions)textSearchOptions));
        return this;
    }

    public MongoQuery where(String javaScriptExpression) {
        this.query.add(Filters.where((String)javaScriptExpression));
        return this;
    }

    public MongoQuery elemMatch(String key, MongoQuery query) {
        this.query.add(Filters.elemMatch((String)key, (Bson)MongoQuery.and(query.getQuery())));
        return this;
    }

    public MongoQuery size(String key, int size) {
        this.query.add(Filters.size((String)key, (int)size));
        return this;
    }

    public MongoQuery geo(MongoGeospatial geo) {
        this.query.add(geo.getQuery());
        return this;
    }

    public MongoQuery in(String key, List values) {
        if ("_id".equals(key)) {
            ArrayList<ObjectId> idList = new ArrayList<ObjectId>();
            for (Object value : values) {
                idList.add(new ObjectId(String.valueOf(value)));
            }
            this.query.add(Filters.in((String)key, idList));
        } else {
            this.query.add(Filters.in((String)key, (Iterable)values));
        }
        return this;
    }

    public MongoQuery gt(String key, Object value) {
        this.query.add(Filters.gt((String)key, (Object)value));
        return this;
    }

    public MongoQuery lt(String key, Object value) {
        this.query.add(Filters.lt((String)key, (Object)value));
        return this;
    }

    public MongoQuery gte(String key, Object value) {
        this.query.add(Filters.gte((String)key, (Object)value));
        return this;
    }

    public MongoQuery lte(String key, Object value) {
        this.query.add(Filters.lte((String)key, (Object)value));
        return this;
    }

    public MongoQuery modify(String key, MongoQuery query) {
        this.modify(key, query.getDocument());
        return this;
    }

    public MongoQuery modify(String key, Object value) {
        if (MongoDocumentKit.conversionValidation(value)) {
            this.data.add(Updates.set((String)key, (Object)MongoDocumentKit.toDocument(value)));
        } else {
            this.data.add(Updates.set((String)key, (Object)value));
        }
        return this;
    }

    public MongoQuery inc(String key, Number value) {
        this.data.add(Updates.inc((String)key, (Number)value));
        return this;
    }

    public MongoQuery like(String key, String value) {
        Pattern pattern = Pattern.compile(value, 2);
        this.query.add(Filters.regex((String)key, (Pattern)pattern));
        return this;
    }

    public MongoQuery like(int type, String key, String value) {
        if (type == 1) {
            Pattern pattern = Pattern.compile("^" + value + ".*$", 2);
            this.query.add(Filters.regex((String)key, (Pattern)pattern));
        } else {
            Pattern pattern = Pattern.compile("^.*" + value + "$", 2);
            this.query.add(Filters.regex((String)key, (Pattern)pattern));
        }
        return this;
    }

    public MongoQuery byId(String id) {
        this.query.add((Bson)new Document("_id", (Object)new ObjectId(id)));
        return this;
    }

    public boolean save() {
        try {
            MongoKit.INSTANCE.insert(this.collectionName, this.document);
            this.id = this.document.getObjectId((Object)"_id").toString();
            this.document.clear();
            return true;
        }
        catch (RuntimeException e) {
            MongoKit.INSTANCE.error("MongoQuery.class", e.getMessage());
            return false;
        }
    }

    public boolean saveList() {
        return this.saveList(false);
    }

    public boolean saveList(boolean fast) {
        try {
            InsertManyOptions ops = new InsertManyOptions();
            if (fast) {
                ops.ordered(false);
            }
            MongoKit.INSTANCE.insert(this.collectionName, this.documents, ops);
            this.documents.clear();
            return true;
        }
        catch (RuntimeException e) {
            MongoKit.INSTANCE.error("MongoQuery.class", e.getMessage());
            return false;
        }
    }

    public MongoQuery projection(String ... keys) {
        BasicDBObject dbObj = new BasicDBObject();
        for (String key : keys) {
            dbObj.append(key, (Object)1);
        }
        this.projection = dbObj;
        return this;
    }

    public MongoQuery limit(int i) {
        this.limit = i;
        return this;
    }

    public MongoQuery skip(int i) {
        this.skip = i;
        return this;
    }

    public List<JSONObject> findAll() {
        return MongoKit.INSTANCE.find(this.collectionName, this.limit, this.skip, this.sort, this.projection, this.join);
    }

    public <T> List findAll(Class<T> clazz) {
        return MongoKit.INSTANCE.find(this.collectionName, this.limit, this.skip, this.sort, this.projection, this.join, clazz);
    }

    public JSONObject findOne() {
        return MongoKit.INSTANCE.findOne(this.collectionName, MongoQuery.and(this.query), this.sort, this.join);
    }

    public <T> T findOne(Class<T> clazz) {
        return MongoKit.INSTANCE.findOne(this.collectionName, MongoQuery.and(this.query), this.sort, this.join, clazz);
    }

    public List<JSONObject> find() {
        return MongoKit.INSTANCE.find(this.collectionName, MongoQuery.and(this.query), this.sort, this.projection, this.limit, this.skip, this.join);
    }

    public <T> List find(Class<T> clazz) {
        return MongoKit.INSTANCE.find(this.collectionName, MongoQuery.and(this.query), this.sort, this.projection, this.limit, this.skip, this.join, clazz);
    }

    public MongoQuery ascending(String ... keys) {
        this.sort = Sorts.ascending(Arrays.asList(keys));
        return this;
    }

    public MongoQuery descending(String ... keys) {
        this.sort = Sorts.descending(Arrays.asList(keys));
        return this;
    }

    public long count() {
        return MongoKit.INSTANCE.count(this.collectionName, MongoQuery.and(this.query));
    }

    public JSONObject max(String key) {
        this.descending(key);
        return this.findOne();
    }

    public <T> T max(String key, Class<T> clazz) {
        this.descending(key);
        return this.findOne(clazz);
    }

    public JSONObject min(String key) {
        this.ascending(key);
        return this.findOne();
    }

    public <T> T min(String key, Class<T> clazz) {
        this.ascending(key);
        return this.findOne(clazz);
    }

    public MongoQuery exist(String key) {
        this.set(Filters.exists((String)key));
        return this;
    }

    public boolean exist() {
        return this.count() > 0L;
    }

    public long update() {
        return MongoKit.INSTANCE.update(this.collectionName, MongoQuery.and(this.query), Updates.combine(this.data));
    }

    public boolean updateOne() {
        return MongoKit.INSTANCE.updateOne(this.collectionName, MongoQuery.and(this.query), Updates.combine(this.data)) > 0L;
    }

    public long replace(Object obj) {
        Document doc = MongoDocumentKit.toDocument(obj);
        doc.remove((Object)"_id");
        return MongoKit.INSTANCE.replaceOne(this.collectionName, MongoQuery.and(this.query), doc);
    }

    public long delete() {
        return MongoKit.INSTANCE.delete(this.collectionName, MongoQuery.and(this.query));
    }

    public boolean deleteOne() {
        return MongoKit.INSTANCE.deleteOne(this.collectionName, MongoQuery.and(this.query)) > 0L;
    }
}

