/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit.aggregation;

import com.alibaba.fastjson.JSONObject;
import com.cybermkd.mongo.kit.MongoKit;
import com.cybermkd.mongo.kit.MongoQuery;
import com.cybermkd.mongo.kit.aggregation.MongoAccumulator;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.GraphLookupOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UnwindOptions;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;

public class MongoAggregation {
    private MongoQuery query;
    private List<Bson> pipeline = new ArrayList<Bson>();
    private List<Bson> projections = new ArrayList<Bson>();
    private UnwindOptions unwindOptions = new UnwindOptions();
    private boolean allowDiskUse = true;

    public MongoAggregation(MongoQuery query) {
        this.query = query;
        if (query.getQuery() != null && !query.getQuery().isEmpty()) {
            this.pipeline.add(Aggregates.match((Bson)Filters.and(query.getQuery())));
        }
        if (query.getSort() != null) {
            this.pipeline.add(Aggregates.sort((Bson)query.getSort()));
        }
        if (query.getSkip() > 0) {
            this.pipeline.add(Aggregates.skip((int)query.getSkip()));
        }
        if (query.getLimit() > 0) {
            this.pipeline.add(Aggregates.limit((int)query.getLimit()));
        }
    }

    public MongoQuery getQuery() {
        return this.query;
    }

    public void setQuery(MongoQuery query) {
        this.query = query;
    }

    public void preserveNullAndEmptyArrays(Boolean preserveNullAndEmptyArrays) {
        this.unwindOptions.preserveNullAndEmptyArrays(preserveNullAndEmptyArrays);
    }

    public MongoAggregation includeArrayIndex(String arrayIndexFieldName) {
        this.unwindOptions.includeArrayIndex(arrayIndexFieldName);
        return this;
    }

    public MongoAggregation unwind(String field) {
        this.pipeline.add(Aggregates.unwind((String)field, (UnwindOptions)this.unwindOptions));
        return this;
    }

    public MongoAggregation unwind(String field, UnwindOptions unwindOptions) {
        this.pipeline.add(Aggregates.unwind((String)field, (UnwindOptions)unwindOptions));
        return this;
    }

    public MongoAggregation projection() {
        this.pipeline.add(Aggregates.project((Bson)Projections.fields(this.projections)));
        return this;
    }

    public MongoAggregation include(String ... fieldNames) {
        this.projections.add(Projections.include((String[])fieldNames));
        return this;
    }

    public MongoAggregation exclude(String ... fieldNames) {
        this.projections.add(Projections.exclude((String[])fieldNames));
        return this;
    }

    public MongoAggregation excludeId() {
        this.projections.add(Projections.excludeId());
        return this;
    }

    public MongoAggregation sample(int size) {
        this.pipeline.add(Aggregates.sample((int)size));
        return this;
    }

    public MongoAggregation lookup(String from, String localField, String foreignField, String as) {
        this.pipeline.add(Aggregates.lookup((String)from, (String)localField, (String)foreignField, (String)as));
        return this;
    }

    public <TExpression> MongoAggregation grahpLookup(String from, TExpression startWith, String connectFromField, String connectToField, String as, GraphLookupOptions options) {
        this.pipeline.add(Aggregates.graphLookup((String)from, startWith, (String)connectFromField, (String)connectToField, (String)as, (GraphLookupOptions)options));
        return this;
    }

    public MongoAggregation out(String collectionName) {
        this.pipeline.add(Aggregates.out((String)collectionName));
        return this;
    }

    public MongoAggregation group(String fieldName, MongoAccumulator accumulator) {
        this.pipeline.add(Aggregates.group((Object)fieldName, accumulator.getAccumulators()));
        return this;
    }

    public MongoAggregation group(Bson bson) {
        this.pipeline.add(Aggregates.group((Object)bson, (BsonField[])new BsonField[0]));
        return this;
    }

    public MongoAggregation addFields(List<Field<?>> fields) {
        this.pipeline.add(Aggregates.addFields(fields));
        return this;
    }

    public MongoAggregation allowDiskUse(boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public MongoAggregation pipeline(Bson bson) {
        this.pipeline.add(bson);
        return this;
    }

    public List<JSONObject> aggregate() {
        return MongoKit.INSTANCE.aggregate(this.query.getCollectionName(), this.pipeline, this.allowDiskUse);
    }

    public <T> List aggregate(Class<T> clazz) {
        return MongoKit.INSTANCE.aggregate(this.query.getCollectionName(), this.pipeline, this.allowDiskUse, clazz);
    }
}

