/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit.geospatial;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Position;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;

public class MongoGeospatial {
    private Point point;
    private Bson query;
    private List<List<Double>> list = new ArrayList<List<Double>>();

    public MongoGeospatial() {
    }

    public MongoGeospatial(Double x, Double y) {
        this.set(x, y);
    }

    public MongoGeospatial set(Double x, Double y) {
        this.point = new Point(new Position(x.doubleValue(), y.doubleValue(), new double[0]));
        return this;
    }

    public MongoGeospatial add(Double x, Double y) {
        ArrayList<Double> temp = new ArrayList<Double>();
        temp.add(x);
        temp.add(y);
        this.list.add(temp);
        return this;
    }

    public Point getPoint() {
        return this.point;
    }

    public Bson getQuery() {
        return this.query;
    }

    public List<List<Double>> getList() {
        return this.list;
    }

    public MongoGeospatial near(String filedName, Double maxDistance, Double minDistance) {
        this.query = Filters.near((String)filedName, (Point)this.point, (Double)maxDistance, (Double)minDistance);
        return this;
    }

    public MongoGeospatial nearSphere(String filedName, Double maxDistance, Double minDistance) {
        this.query = Filters.nearSphere((String)filedName, (Point)this.point, (Double)maxDistance, (Double)minDistance);
        return this;
    }

    public MongoGeospatial circle(String filedName, Double radius) {
        this.query = Filters.geoWithinCenter((String)filedName, (double)((Double)this.point.getPosition().getValues().get(0)), (double)((Double)this.point.getPosition().getValues().get(1)), (double)radius);
        return this;
    }

    public MongoGeospatial circleSphere(String filedName, Double radius) {
        this.query = Filters.geoWithinCenterSphere((String)filedName, (double)((Double)this.point.getPosition().getValues().get(0)), (double)((Double)this.point.getPosition().getValues().get(1)), (double)radius);
        return this;
    }

    public MongoGeospatial withinPolygon(String filedName) {
        this.query = Filters.geoWithinPolygon((String)filedName, this.list);
        return this;
    }
}

