/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit.index;

import com.alibaba.fastjson.JSONObject;
import com.cybermkd.mongo.kit.MongoKit;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;

public class MongoIndex
extends IndexOptions {
    private String collectionName;
    private Bson bson;
    private List<IndexModel> indexModels = new ArrayList<IndexModel>();

    public MongoIndex() {
    }

    public MongoIndex(String collectionName) {
        this.collectionName = collectionName;
    }

    public Bson getBson() {
        return this.bson;
    }

    public MongoIndex ascending(String ... keys) {
        this.bson = Indexes.ascending((String[])keys);
        return this;
    }

    public MongoIndex descending(String ... keys) {
        this.bson = Indexes.descending((String[])keys);
        return this;
    }

    public MongoIndex geo2dsphere(String ... keys) {
        this.bson = Indexes.geo2dsphere((String[])keys);
        return this;
    }

    public MongoIndex geo2d(String key) {
        this.bson = Indexes.geo2d((String)key);
        return this;
    }

    public MongoIndex geoHaystack(String key, Bson additional) {
        this.bson = Indexes.geoHaystack((String)key, (Bson)additional);
        return this;
    }

    public MongoIndex text(String key) {
        this.bson = Indexes.text((String)key);
        return this;
    }

    public MongoIndex hashed(String key) {
        this.bson = Indexes.hashed((String)key);
        return this;
    }

    public List<JSONObject> get() {
        return MongoKit.INSTANCE.getIndex(this.collectionName);
    }

    public String save() {
        return MongoKit.INSTANCE.setIndex(this.collectionName, this.bson);
    }

    public void delete() {
        MongoKit.INSTANCE.deleteIndex(this.collectionName, this.bson);
    }

    public void deleteAll() {
        MongoKit.INSTANCE.deleteIndex(this.collectionName);
    }

    public MongoIndex add(MongoIndex mongoIndex) {
        this.indexModels.add(new IndexModel(Indexes.compoundIndex((Bson[])new Bson[]{mongoIndex.getBson()}), (IndexOptions)mongoIndex));
        return this;
    }

    public List<String> compound() {
        return MongoKit.INSTANCE.setIndex(this.collectionName, this.indexModels);
    }

    public MongoIndex setUnique(boolean unique) {
        this.unique(unique);
        return this;
    }

    public MongoIndex setBackground(boolean background) {
        this.background(background);
        return this;
    }

    public MongoIndex setSparse(boolean sparse) {
        this.sparse(sparse);
        return this;
    }
}

