/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.kit.page;

import com.alibaba.fastjson.JSONObject;
import com.cybermkd.mongo.kit.MongoQuery;
import com.cybermkd.mongo.kit.page.MongoPage;
import java.util.ArrayList;
import java.util.List;

public class MongoPaginate {
    private int count;
    private int page;
    private int totalPage;
    private long totalRow;
    private MongoQuery query;
    private boolean firstPage = false;
    private boolean lastPage = false;
    private List<JSONObject> list = new ArrayList<JSONObject>();

    public MongoPaginate(MongoQuery query, int count, int page) {
        this.query = query;
        this.count = count;
        this.page = page;
        this.totalRow = this.count();
        this.totalPage = (int)(this.totalRow / (long)count);
        if (this.totalRow % (long)count != 0L) {
            ++this.totalPage;
        }
        if ((long)count > this.totalRow) {
            this.count = (int)this.totalRow;
        }
        if (this.totalRow != 0L && this.count <= 0 || this.page <= 0) {
            throw new RuntimeException("MongPage tips: (\u3065\uffe3 3\uffe3)\u3065 count or page is error !");
        }
        this.firstPage = this.page == 1;
        this.lastPage = this.page == this.totalPage;
    }

    public MongoPage find() {
        this.list = this.query.limit(this.count).skip(this.skip()).find();
        return new MongoPage(this.count, this.page, this.totalPage, this.totalRow, this.firstPage, this.lastPage, this.list);
    }

    public <T> MongoPage find(Class<T> clazz) {
        this.list = this.query.limit(this.count).skip(this.skip()).find(clazz);
        return new MongoPage(this.count, this.page, this.totalPage, this.totalRow, this.firstPage, this.lastPage, this.list);
    }

    public MongoPage findAll() {
        this.list = this.query.limit(this.count).skip(this.skip()).findAll();
        return new MongoPage(this.count, this.page, this.totalPage, this.totalRow, this.firstPage, this.lastPage, this.list);
    }

    public <T> MongoPage findAll(Class<T> clazz) {
        this.list = this.query.limit(this.count).skip(this.skip()).findAll(clazz);
        return new MongoPage(this.count, this.page, this.totalPage, this.totalRow, this.firstPage, this.lastPage, this.list);
    }

    private int skip() {
        if (this.firstPage) {
            return 0;
        }
        return (this.page - 1) * this.count;
    }

    public int count() {
        return (int)this.query.count();
    }
}

