/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.plugin;

import com.cybermkd.mongo.kit.MongoKit;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;

public class MongoPlugin {
    private MongoClientOptions.Builder options = MongoClientOptions.builder();
    private List<ServerAddress> hostList = new ArrayList<ServerAddress>();
    private List<MongoCredential> authList = new ArrayList<MongoCredential>();
    private String database;

    public MongoPlugin add(String host) {
        this.hostList.add(new ServerAddress(host, 27017));
        return this;
    }

    public MongoPlugin add(String host, int port) {
        this.hostList.add(new ServerAddress(host, port));
        return this;
    }

    public MongoPlugin setDatabase(String database) {
        this.database = database;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public MongoPlugin auth(MongoCredential mongoCredential) {
        this.authList.add(mongoCredential);
        return this;
    }

    public MongoPlugin auth(String username, String password) {
        this.authList.add(MongoCredential.createScramSha1Credential((String)username, (String)this.database, (char[])password.toCharArray()));
        return this;
    }

    public MongoPlugin authCR(String username, String password) {
        this.authList.add(MongoCredential.createMongoCRCredential((String)username, (String)this.database, (char[])password.toCharArray()));
        return this;
    }

    public MongoPlugin authX509(String x509) {
        this.authList.add(MongoCredential.createMongoX509Credential((String)x509));
        return this;
    }

    public MongoPlugin ssl() {
        this.options.sslEnabled(true);
        return this;
    }

    public MongoPlugin connectTimeout(int connectTimeout) {
        this.options.connectTimeout(connectTimeout);
        return this;
    }

    public MongoPlugin opition(MongoClientOptions.Builder opitions) {
        this.options = opitions;
        return this;
    }

    public MongoPlugin readPreference(ReadPreference readPreference) {
        this.options.readPreference(readPreference);
        return this;
    }

    public MongoPlugin readPreference() {
        this.options.readPreference(ReadPreference.secondaryPreferred());
        return this;
    }

    public MongoPlugin writeConcern(WriteConcern writeConcern) {
        this.options.writeConcern(writeConcern);
        return this;
    }

    public MongoPlugin writeConcern() {
        this.options.writeConcern(WriteConcern.JOURNALED);
        return this;
    }

    public MongoPlugin writeSafe() {
        this.options.writeConcern(WriteConcern.MAJORITY);
        return this;
    }

    public MongoPlugin setDebug(boolean debug) {
        MongoKit.INSTANCE.setDebug(debug);
        return this;
    }

    public MongoClient getMongoClient() {
        try {
            return new MongoClient(this.hostList, this.authList, this.options.build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u8fde\u63a5mongodb,\u8bf7\u68c0\u67e5\u914d\u7f6e!Can't connect mongodb!");
        }
    }
}

