/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.validation;

import com.cybermkd.mongo.constraints.Chinese;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ChineseValidator
implements ConstraintValidator<Chinese, String> {
    private boolean value = false;

    public void initialize(Chinese chinese) {
        this.value = chinese.value();
    }

    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (this.value) {
            return ChineseValidator.isChinese(s);
        }
        return !ChineseValidator.isChinese(s);
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!ChineseValidator.isChinese(c)) continue;
            return true;
        }
        return false;
    }
}

