/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.validation;

import com.cybermkd.mongo.constraints.Exist;
import com.cybermkd.mongo.kit.MongoQuery;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ExistValidator
implements ConstraintValidator<Exist, String> {
    private boolean value = false;
    private String collectionName = "";
    private String key = "";

    public void initialize(Exist exist) {
        this.value = exist.value();
        this.collectionName = exist.collectionName();
        this.key = exist.key();
    }

    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (this.value) {
            return this.exist(s);
        }
        return !this.exist(s);
    }

    private boolean exist(String s) {
        MongoQuery query = new MongoQuery().use(this.collectionName);
        if (this.key.equals("id") || this.key.equals("_id")) {
            query.byId(s);
        } else {
            query.eq(this.key, s);
        }
        return query.exist();
    }
}

