/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.mongo.validation;

import com.cybermkd.mongo.constraints.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class TypeValidator
implements ConstraintValidator<Type, String> {
    private String value = "string";

    public void initialize(Type type) {
        this.value = type.value();
    }

    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (this.value.equals("int")) {
            return this.isInt(s);
        }
        if (this.value.equals("double")) {
            return this.isDouble(s);
        }
        if (this.value.equals("boolean")) {
            return this.isDouble(s);
        }
        return true;
    }

    private boolean isInt(String s) {
        Matcher mer = Pattern.compile("^[+-]?[0-9]+$").matcher(s);
        return mer.find();
    }

    private boolean isDouble(String s) {
        Matcher mer = Pattern.compile("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$").matcher(s);
        return mer.find();
    }

    private boolean isBoolean(String s) {
        return s.equals("true") || s.equals("false");
    }
}

