/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.PostgisWkbParser;
import org.geolatte.geom.codec.WkbDialect;
import org.geolatte.geom.codec.support.GeometryBuilder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.Unit;

public class DmWkbParser<P extends Position>
extends PostgisWkbParser<P> {
    private boolean crsRead = false;
    private int srid = 0;

    DmWkbParser(WkbDialect dialect, ByteBuffer buffer, CoordinateReferenceSystem<P> crs) {
        super(dialect, buffer, crs);
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    protected GeometryBuilder parseWkbType() {
        long tpe = this.buffer.getUInt();
        this.gtype = this.dialect.parseType(tpe);
        if (!this.crsRead) {
            this.readCrs(this.buffer, (int)tpe);
            this.crsRead = true;
        }
        return GeometryBuilder.create((GeometryType)this.gtype);
    }

    protected void readCrs(ByteBuffer byteBuffer, int typeCode) {
        this.hasM = (typeCode & 0x40000000) == 0x40000000;
        this.hasZ = (typeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        CoordinateReferenceSystem crsDeclared = CrsRegistry.ifAbsentReturnProjected2D((int)this.srid);
        if (this.hasZ) {
            crsDeclared = CoordinateReferenceSystems.addVerticalSystem((CoordinateReferenceSystem)crsDeclared, (LinearUnit)Unit.METER);
        }
        if (this.hasM) {
            crsDeclared = CoordinateReferenceSystems.addLinearSystem((CoordinateReferenceSystem)crsDeclared, (LinearUnit)Unit.METER);
        }
        this.embeddedCRS = crsDeclared;
    }
}

