/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DmDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmGeometryTypeDescriptor;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DmSpatialDialect
extends DmDialect
implements SpatialDialect {
    private static final long serialVersionUID = 1L;

    public DmSpatialDialect() {
        this.registerTypesAndFunctions();
    }

    private DmGeometryTypeDescriptor mkDescriptor(ServiceRegistry serviceRegistry) {
        return new DmGeometryTypeDescriptor();
    }

    protected void registerTypesAndFunctions() {
        this.registerColumnType(2002, "SYSGEO2.ST_Geometry");
        this.registerColumnType(2002, "SYSGEO2.ST_Point");
        this.registerColumnType(2002, "SYSGEO2.ST_Linestring");
        this.registerColumnType(2002, "SYSGEO2.ST_Polygon");
        this.registerColumnType(2002, "SYSGEO2.ST_GeometryCollection");
        this.registerColumnType(2002, "SYSGEO2.ST_MultiPoint");
        this.registerColumnType(2002, "SYSGEO2.ST_MultiLineString");
        this.registerColumnType(2002, "SYSGEO2.ST_MultiPolygon");
        this.registerColumnType(2002, "SYSGEO2.ST_PolyhedralSurface");
        this.registerColumnType(2002, "SYSGEO2.ST_Triangle");
        this.registerColumnType(2002, "SYSGEO2.ST_TIN");
        this.registerColumnType(2002, "SYSGEO2.ST_CircularString");
        this.registerColumnType(2002, "SYSGEO2.ST_CompoundCurve");
        this.registerColumnType(2002, "SYSGEO2.ST_CurvePolygon");
        this.registerColumnType(2002, "SYSGEO2.ST_MultiCurve");
        this.registerColumnType(2002, "SYSGEO2.ST_MultiSurface");
        this.registerColumnType(2002, "SYSGEO2.ST_PolyhedralSurface");
        this.registerColumnType(2002, "SYSGEO2.ST_Geography");
        this.registerColumnType(2002, "SYSGEO2.ST_Box2D");
        this.registerColumnType(2002, "SYSGEO2.ST_Box3D");
        this.registerColumnType(2002, "SYSGEO2.GEOMETRY_SHAPEARRAY");
        this.registerColumnType(2002, "SYSGEO2.GEOMETRY_DUMP");
        this.registerColumnType(2002, "SYSGEO2.VALID_DETAIL");
        this.registerColumnType(2002, "SYSGEO2.ST_GeometryCollection");
        this.registerColumnType(2002, "SYSGEO2.GEOMETRY_INSCRIBEDCIRCLEARRAY");
        this.registerColumnType(2002, "SYSGEO2.GEOMETRY_RADIUSARRAY");
        this.registerColumnType(2002, "SYSGEO2.ClusterArray");
        this.registerFunction("AddGeometryColumn", (SQLFunction)new StandardSQLFunction("dmgeo2.AddGeometryColumn", null));
        this.registerFunction("DropGeometryColumn", (SQLFunction)new StandardSQLFunction("dmgeo2.DropGeometryColumn", null));
        this.registerFunction("DropGeometryTable", (SQLFunction)new StandardSQLFunction("dmgeo2.DropGeometryColumn", null));
        this.registerFunction("FIND_SRID", (SQLFunction)new StandardSQLFunction("dmgeo2.FIND_SRID", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("ModifyGeometryColumn", (SQLFunction)new StandardSQLFunction("dmgeo2.ModifyGeometryColumn", null));
        this.registerFunction("Collect", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Collect", null));
        this.registerFunction("LineFromMultiPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromMultiPoint", null));
        this.registerFunction("MakeEnvelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeEnvelope", null));
        this.registerFunction("MakeLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeLine", null));
        this.registerFunction("MakePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakePoint", null));
        this.registerFunction("MakePointM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakePointM", null));
        this.registerFunction("MakePolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakePolygon", null));
        this.registerFunction("Point", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Point", null));
        this.registerFunction("PointZ", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointZ", null));
        this.registerFunction("PointM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointM", null));
        this.registerFunction("PointZM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointZM", null));
        this.registerFunction("Polygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Polygon", null));
        this.registerFunction("TileEnvelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_TileEnvelope", null));
        this.registerFunction("HexagonGrid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_HexagonGrid", null));
        this.registerFunction("Hexagon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Hexagon", null));
        this.registerFunction("SquareGrid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SquareGrid", null));
        this.registerFunction("Square", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Square", null));
        this.registerFunction("CreateCircle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateCircle", null));
        this.registerFunction("CreateArc", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateArc", null));
        this.registerFunction("CreateArcPolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateArcPolygon", null));
        this.registerFunction("CreateAnnulus", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateAnnulus", null));
        this.registerFunction("CreateAnnularSector", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateAnnularSector", null));
        this.registerFunction("ELLIPSE_POLYGON", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ELLIPSE_POLYGON", null));
        this.registerFunction("CIRCLE_POLYGON", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CIRCLE_POLYGON", null));
        this.registerFunction("ST_GeometryType", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometryType", (Type)StandardBasicTypes.TEXT));
        this.registerFunction("GeometryType", (SQLFunction)new StandardSQLFunction("dmgeo2.GeometryType", (Type)StandardBasicTypes.TEXT));
        this.registerFunction("Boundary", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Boundary", null));
        this.registerFunction("BoundingDiagonal", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoundingDiagonal", null));
        this.registerFunction("CoordDim", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CoordDim", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Dimension", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Dump", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Dump", null));
        this.registerFunction("DumpPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DumpPoints", null));
        this.registerFunction("DumpSegments", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DumpSegments", null));
        this.registerFunction("DumpRings", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DumpRings", null));
        this.registerFunction("EndPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EndPoint", null));
        this.registerFunction("Envelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Envelope", null));
        this.registerFunction("ExteriorRing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ExteriorRing", null));
        this.registerFunction("GeometryN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometryN", null));
        this.registerFunction("HasArc", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_HasArc", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("InteriorRingN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_InteriorRingN", null));
        this.registerFunction("IsClosed", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsClosed", null));
        this.registerFunction("IsCollection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsCollection", null));
        this.registerFunction("IsEmpty", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsEmpty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsPolygonCCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsPolygonCCW", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsPolygonCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsPolygonCW", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsRing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsRing", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsSimple", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsSimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("M", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_M", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MemSize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MemSize", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NDims", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NDims", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NPoints", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NRings", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NRings", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumGeometries", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumGeometries", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumInteriorRings", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumInteriorRings", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumInteriorRing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumInteriorRing", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumPatches", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumPatches", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumPoints", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("PatchN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PatchN", null));
        this.registerFunction("PointN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointN", null));
        this.registerFunction("Points", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Points", null));
        this.registerFunction("StartPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StartPoint", null));
        this.registerFunction("Summary", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Summary", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("X", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_X", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Y", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Y", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Z", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Z", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Zmflag", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Zmflag", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("GET_TYPE", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GET_TYPE", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("AddPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AddPoint", null));
        this.registerFunction("CollectionExtract", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CollectionExtract", null));
        this.registerFunction("CollectionHomogenize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CollectionHomogenize", null));
        this.registerFunction("CurveToLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CurveToLine", null));
        this.registerFunction("Scroll", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Scroll", null));
        this.registerFunction("FilpCoordinates", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FilpCoordinates", null));
        this.registerFunction("Force2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force2D", null));
        this.registerFunction("Force3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force3D", null));
        this.registerFunction("Force3DZ", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force3DZ", null));
        this.registerFunction("Force3DM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force3DM", null));
        this.registerFunction("Force4D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force4D", null));
        this.registerFunction("ForcePolygonCCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForcePolygonCCW", null));
        this.registerFunction("ForceCollection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceCollection", null));
        this.registerFunction("ForcePolygonCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForcePolygonCW", null));
        this.registerFunction("ForceSFS", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceSFS", null));
        this.registerFunction("ForceRHR", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceRHR", null));
        this.registerFunction("ForceCurve", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceCurve", null));
        this.registerFunction("LineToCurve", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineToCurve", null));
        this.registerFunction("Multi", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Multi", null));
        this.registerFunction("Normalize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Normalize", null));
        this.registerFunction("QuantizeCoordinates", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_QuantizeCoordinates", null));
        this.registerFunction("RemovePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RemovePoint", null));
        this.registerFunction("RemoveRepeatedPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RemoveRepeatedPoints", null));
        this.registerFunction("Reverse", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Reverse", null));
        this.registerFunction("Segmentize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Segmentize", null));
        this.registerFunction("SetPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SetPoint", null));
        this.registerFunction("ShiftLongitude", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ShiftLongitude", null));
        this.registerFunction("WrapX", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_WrapX", null));
        this.registerFunction("SnapToGrid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SnapToGrid", null));
        this.registerFunction("Snap", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Snap", null));
        this.registerFunction("SwapOrdinates", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SwapOrdinates", null));
        this.registerFunction("ForcePolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForcePolygon", null));
        this.registerFunction("IsValid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValid", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsValidDetail", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValidDetail", null));
        this.registerFunction("IsValidReason", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValidReason", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("MakeValid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeValid", null));
        this.registerFunction("CleanGeometry", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CleanGeometry", null));
        this.registerFunction("VALIDATE_LAYER_WITH_CONTEXT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_VALIDATE_LAYER_WITH_CONTEXT", null));
        this.registerFunction("SetSRID", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SetSRID", null));
        this.registerFunction("SRID", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SRID", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Transform", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Transform", null));
        this.registerFunction("BdPolyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BdPolyFromText", null));
        this.registerFunction("BdMPolyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BdMPolyFromText", null));
        this.registerFunction("GeogFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeogFromText", null));
        this.registerFunction("GeographyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeographyFromText", null));
        this.registerFunction("GeomCollFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomCollFromText", null));
        this.registerFunction("GeomFromEWKT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromEWKT", null));
        this.registerFunction("GeomFromMARC21", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromMARC21", null));
        this.registerFunction("GeometryFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometryFromText", null));
        this.registerFunction("GeomFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromText", null));
        this.registerFunction("LineFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromText", null));
        this.registerFunction("MultiLineStringFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiLineStringFromText", null));
        this.registerFunction("MLineFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MLineFromText", null));
        this.registerFunction("MultiPointFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPointFromText", null));
        this.registerFunction("MPointFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MPointFromText", null));
        this.registerFunction("MultiPolygonFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPolygonFromText", null));
        this.registerFunction("MPolyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MPolyFromText", null));
        this.registerFunction("PointFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointFromText", null));
        this.registerFunction("PolygonFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PolygonFromText", null));
        this.registerFunction("WKTToSQL", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_WKTToSQL", null));
        this.registerFunction("GeogFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeogFromWKB", null));
        this.registerFunction("GeomFromEWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromEWKB", null));
        this.registerFunction("GeomFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromWKB", null));
        this.registerFunction("LineFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromWKB", null));
        this.registerFunction("LinestringFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LinestringFromWKB", null));
        this.registerFunction("MultiLineFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiLineFromWKB", null));
        this.registerFunction("PointFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointFromWKB", null));
        this.registerFunction("MultiPointFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPointFromWKB", null));
        this.registerFunction("PolygonFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PolygonFromWKB", null));
        this.registerFunction("MultiPolyFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPolyFromWKB", null));
        this.registerFunction("GeomCollFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomCollFromWKB", null));
        this.registerFunction("WKBToSQL", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_WKBToSQL", null));
        this.registerFunction("Box2dFromGeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Box2dFromGeoHash", null));
        this.registerFunction("GeomFromGeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGeoHash", null));
        this.registerFunction("GeomFromGML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGML", null));
        this.registerFunction("GeomFromGeoJson", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGeoJson", null));
        this.registerFunction("GeomFromKML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromKML", null));
        this.registerFunction("GeomFromTWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromTWKB", null));
        this.registerFunction("GMLToSQL", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GMLToSQL", null));
        this.registerFunction("LineFromEncodedPolyline", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromEncodedPolyline", null));
        this.registerFunction("PointFromGeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointFromGeoHash", null));
        this.registerFunction("AsEWKT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsEWKT", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsText", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsBinary", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsBinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("AsEWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsEWKB", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("AsHexEWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsHexEWKB", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsEncodedPolyline", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsEncodedPolyline", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsGeoJSON", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsGeoJSON", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsGML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsGML", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsKML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsKML", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsLatLonText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsLatLonText", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsMARC21", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsMARC21", null));
        this.registerFunction("AsMVTGeom", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsMVTGeom", null));
        this.registerFunction("AsSVG", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsSVG", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("AsTWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsTWKB", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("AsX3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsX3D", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("GeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeoHash", (Type)StandardBasicTypes.CLOB));
        this.registerFunction("3Dintersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3Dintersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Contains", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("ContainsProperly", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ContainsProperly", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("CoveredBy", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CoveredBy", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Covers", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Covers", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Crosses", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("LineCrossingDirection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineCrossingDirection", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Disjoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Equals", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Intersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("OrderingEquals", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_OrderingEquals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Overlaps", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Relate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Relate", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("RelateMatch", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RelateMatch", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Touches", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Within", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("3DDWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("3DDFullyWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDFullyWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("DFullyWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DFullyWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("DWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("PointInsideCircle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointInsideCircle", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Area", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Area", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Area2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Area2D", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Azimuth", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Azimuth", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Angle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Angle", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ClosestPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClosestPoint", null));
        this.registerFunction("3DClosestPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DClosestPoint", null));
        this.registerFunction("Distance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("3DDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("DistanceSphere", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DistanceSphere", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("DistanceSpheroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DistanceSpheroid", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("FrechetDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FrechetDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("HaudorffDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_HaudorffDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Length", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Length", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Length2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Length2D", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("3DLength", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DLength", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LengthSpheroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LengthSpheroid", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Length2DSpheroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Length2DSpheroid", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LongestLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LongestLine", null));
        this.registerFunction("3DLongestLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DLongestLine", null));
        this.registerFunction("MaxDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MaxDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("3DMaxDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DMaxDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MinimumClearance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumClearance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MinimumClearanceLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumClearanceLine", null));
        this.registerFunction("Perimeter", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Perimeter", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Perimeter2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Perimeter2D", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("3DPerimeter", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DPerimeter", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Project", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Project", null));
        this.registerFunction("ShortestLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ShortestLine", null));
        this.registerFunction("3DShortestLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DShortestLine", null));
        this.registerFunction("ClipByBox2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClipByBox2D", null));
        this.registerFunction("Difference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Difference", null));
        this.registerFunction("Intersection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Intersection", null));
        this.registerFunction("Node", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Node", null));
        this.registerFunction("Split", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Split", null));
        this.registerFunction("Subdivide", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Subdivide", null));
        this.registerFunction("SymDifference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SymDifference", null));
        this.registerFunction("UnaryUnion", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_UnaryUnion", null));
        this.registerFunction("SymMetricDifference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SymMetricDifference", null));
        this.registerFunction("GeomUnion", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Union", null));
        this.registerFunction("Xor", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Xor", null));
        this.registerFunction("UNION_AGG", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_UNION_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("CombineBBox", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CombineBBox", null));
        this.registerFunction("Buffer", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Buffer", null));
        this.registerFunction("BuildArea", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BuildArea", null));
        this.registerFunction("Centroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Centroid", null));
        this.registerFunction("ConcaveHull", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ConcaveHull", null));
        this.registerFunction("ConvexHull", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ConvexHull", null));
        this.registerFunction("DelaunayTriangles", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DelaunayTriangles", null));
        this.registerFunction("FilterByM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FilterByM", null));
        this.registerFunction("GeneratePoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeneratePoints", null));
        this.registerFunction("GeometricMedian", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometricMedian", null));
        this.registerFunction("LineMerge", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineMerge", null));
        this.registerFunction("MaximumInscribedCricle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MaximumInscribedCricle", null));
        this.registerFunction("MinimumBoundingCircle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumBoundingCircle", null));
        this.registerFunction("MinimumBoundingRadius", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumBoundingRadius", null));
        this.registerFunction("OrientedEnvelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_OrientedEnvelope", null));
        this.registerFunction("OffsetCurve", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_OffsetCurve", null));
        this.registerFunction("PointOnSurface", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointOnSurface", null));
        this.registerFunction("Polygonize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Polygonize", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("ReducePrecision", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ReducePrecision", null));
        this.registerFunction("SharedPaths", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SharedPaths", null));
        this.registerFunction("Simplify", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Simplify", null));
        this.registerFunction("SimplifyPolygonHull", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SimplifyPolygonHull", null));
        this.registerFunction("SimplifyVW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SimplifyVW", null));
        this.registerFunction("ChaikinSmoothing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ChaikinSmoothing", null));
        this.registerFunction("SetEffectiveArea", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SetEffectiveArea", null));
        this.registerFunction("TriangulatePolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_TriangulatePolygon", null));
        this.registerFunction("VoronoiLines", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_VoronoiLines", null));
        this.registerFunction("VoronoiPolygons", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_VoronoiPolygons", null));
        this.registerFunction("CENTROID_AGG", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CENTROID_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("CONVEXHULL_AGG", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CONVEXHULL_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("Affine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Affine", null));
        this.registerFunction("Rotate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Rotate", null));
        this.registerFunction("RotateX", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RotateX", null));
        this.registerFunction("RotateY", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RotateY", null));
        this.registerFunction("RotateZ", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RotateZ", null));
        this.registerFunction("Scale", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Scale", null));
        this.registerFunction("Translate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Translate", null));
        this.registerFunction("TransScale", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_TransScale", null));
        this.registerFunction("ClusterDBSCAN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClusterDBSCAN", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("ClusterIntersecting", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClusterIntersecting", null));
        this.registerFunction("ClusterWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClusterWithin", null));
        this.registerFunction("Box2D", (SQLFunction)new StandardSQLFunction("dmgeo2.Box2D", null));
        this.registerFunction("Box3D", (SQLFunction)new StandardSQLFunction("dmgeo2.Box3D", null));
        this.registerFunction("EstimatedExtent", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EstimatedExtent", null));
        this.registerFunction("Expand", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Expand", null));
        this.registerFunction("Extent", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Extent", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("3DExtent", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DExtent", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("FindExtent", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FindExtent", null));
        this.registerFunction("MakeBox2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeBox2D", null));
        this.registerFunction("3DMakeBox", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DMakeBox", null));
        this.registerFunction("XMax", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_XMax", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("XMin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_XMin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("YMax", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_YMax", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("YMin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_YMin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ZMax", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ZMax", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ZMin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ZMin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("BoxEquals", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxEquals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("2DDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_2DDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Box2DDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Box2DDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("BoxnDDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxnDDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Box2DIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Box2DIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("EnvIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EnvIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Env2DIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Env2DIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("EnvnDIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EnvnDIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxnDIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxnDIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Left", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Left", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Below", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Below", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Right", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Right", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Above", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Above", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictLeft", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictLeft", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictBelow", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictBelow", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictRight", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictRight", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictAbove", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictAbove", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Accordance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Accordance", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxContains", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxContains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxToGeom", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxToGeom", null));
        this.registerFunction("MBR_AGG", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MBR_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("LineInterpolatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineInterpolatePoint", null));
        this.registerFunction("3DLineInterpolatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DLineInterpolatePoint", null));
        this.registerFunction("LineInterpolatePoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineInterpolatePoints", null));
        this.registerFunction("LineLocatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineLocatePoint", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LineSubstring", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineSubstring", null));
        this.registerFunction("LocateAlong", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LocateAlong", null));
        this.registerFunction("LocateBetween", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LocateBetween", null));
        this.registerFunction("LocateBetweenElevations", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LocateBetweenElevations", null));
        this.registerFunction("InterpolatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_InterpolatePoint", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("AddMeasure", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AddMeasure", null));
        this.registerFunction("IsValidTrajectory", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValidTrajectory", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("ClosestPointOfApproach", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClosestPointOfApproach", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("DistanceCPA", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DistanceCPA", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("CPAWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CPAWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("3DArea", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DArea", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("3DIntersection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DIntersection", null));
        this.registerFunction("3DDifference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDifference", null));
        this.registerFunction("3DUnion", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DUnion", null));
        this.registerFunction("ApproximateMedialAxis", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ApproximateMedialAxis", null));
        this.registerFunction("ConstrainedDelaunayTriangles", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ConstrainedDelaunayTriangles", null));
        this.registerFunction("Extrude", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Extrude", null));
        this.registerFunction("ForceLHR", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceLHR", null));
        this.registerFunction("IsPlanar", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsPlanar", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsSolid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsSolid", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("MakeSolid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeSolid", null));
        this.registerFunction("MinkowskiSum", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinkowskiSum", null));
        this.registerFunction("Orientation", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Orientation", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("StraightSkeleton", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StraightSkeleton", null));
        this.registerFunction("Tesselate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Tesselate", null));
        this.registerFunction("Volume", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Volume", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ADD_SPATIAL_REF", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ADD_SPATIAL_REF", null));
        this.registerFunction("DEL_SPATIAL_REF", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DEL_SPATIAL_REF", null));
        this.registerFunction("UPDATE_SRID", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_UPDATE_SRID", null));
        this.registerFunction("CONVERT_UNIT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CONVERT_UNIT", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("GeomToGeog", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomToGeog", null));
        this.registerFunction("GeogToGeom", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeogToGeom", null));
        this.registerFunction("CREATE_GEO2_SYNONYMS", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CREATE_GEO2_SYNONYMS", null));
        this.registerFunction("DELETE_GEO2_SYNONYMS", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DELETE_GEO2_SYNONYMS", null));
        this.registerFunction("SELF_UNION", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SELF_UNION", null));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        DmGeometryTypeDescriptor typeDescriptor = this.mkDescriptor(serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType((SqlTypeDescriptor)typeDescriptor));
        typeContributions.contributeType((BasicType)new JTSGeometryType((SqlTypeDescriptor)typeDescriptor));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException(String.format("Dameng doesn't support the Dwithin function", new Object[0]));
    }

    public String getHavingSridSQL(String columnName) {
        return "( dmgeo2.ST_Srid(" + columnName + ") = ?)";
    }

    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " dmgeo2.ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                StringBuilder stbuf = new StringBuilder();
                stbuf.append("extent(").append(columnName).append(")");
                return stbuf.toString();
            }
        }
        throw new IllegalArgumentException("Aggregation of type " + aggregation + " are not supported by this dialect");
    }

    public String getSpatialFilterExpression(String columnName) {
        return "dmgeo2.ST_Intersects(" + columnName + ", ?)";
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        StringBuffer sql = new StringBuffer("dmgeo2.");
        switch (spatialRelation) {
            case 6: {
                sql.append("ST_Contains");
                break;
            }
            case 3: {
                sql.append("ST_Crosses");
                break;
            }
            case 1: {
                sql.append("ST_Disjoint");
                break;
            }
            case 0: {
                sql.append("ST_Equals");
                break;
            }
            case 7: {
                sql.append("ST_Intersects");
                break;
            }
            case 5: {
                sql.append("ST_Overlaps");
                break;
            }
            case 2: {
                sql.append("ST_Touches");
                break;
            }
            case 4: {
                sql.append("ST_Within");
                break;
            }
            default: {
                throw new IllegalArgumentException("Spatial relation is not known by this dialect");
            }
        }
        sql.append("(").append(columnName).append(", ?) ");
        return sql.toString();
    }

    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }

    public boolean supportsFiltering() {
        return true;
    }
}

