/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import com.dameng.geotools.util.DmGeo2Util;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbStruct;
import java.sql.Connection;
import java.sql.Struct;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;

public class DmStructEncoder {
    public Struct encode(Geometry geom, Connection connection) {
        if (geom == null) {
            return null;
        }
        try {
            WKBWriter wkbwriter = new WKBWriter();
            byte[] ewkb = wkbwriter.write(geom);
            int srid = geom.getSRID();
            byte[] gserialized = DmGeo2Util.wkbToGserGeog((byte[])ewkb, (int)srid);
            DmdbConnection dmConn = (DmdbConnection)connection;
            Object[] attrs = new Object[]{DmdbBlob.newInstanceOfLocal((byte[])gserialized, (DmdbConnection)dmConn)};
            return dmConn.createStruct("SYSGEO2.ST_Geometry", attrs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't parse outcoming Dameng Spatial data.");
        }
    }

    public DmdbStruct encode(Geometry geom) {
        throw new RuntimeException("Couldn't parse outcoming Dameng Spatial data.(No Connection)");
    }

    public boolean accepts(Geometry geom) {
        return false;
    }
}

