/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet;

import com.datasonnet.Mapper;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.spi.DataFormatPlugin;
import com.datasonnet.spi.DataFormatService;
import com.datasonnet.spi.Library;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MapperBuilder {
    private final String script;
    private Iterable<String> inputNames = Collections.emptySet();
    private Map<String, String> imports = Collections.emptyMap();
    private List<Library> libs = Collections.emptyList();
    private DataFormatService service = DataFormatService.DEFAULT;
    private boolean asFunction = true;
    private MediaType defaultOutput = MediaTypes.APPLICATION_JSON;

    public MapperBuilder(String script) {
        this.script = script;
    }

    public MapperBuilder withInputNames(Iterable<String> inputNames) {
        Objects.requireNonNull(inputNames);
        this.inputNames = inputNames;
        return this;
    }

    public MapperBuilder withInputNames(String ... inputNames) {
        this.inputNames = Arrays.asList(inputNames);
        return this;
    }

    public MapperBuilder withInputNamesFrom(Map<String, String> imports) {
        this.inputNames = imports.keySet();
        return this;
    }

    public MapperBuilder withImports(Map<String, String> imports) {
        Objects.requireNonNull(imports);
        this.imports = imports;
        return this;
    }

    public MapperBuilder withLibrary(Library lib) {
        Objects.requireNonNull(lib);
        if (this.libs.isEmpty()) {
            this.libs = new ArrayList<Library>(2);
        }
        this.libs.add(lib);
        return this;
    }

    public MapperBuilder wrapAsFunction(boolean asFunction) {
        this.asFunction = asFunction;
        return this;
    }

    public MapperBuilder configurePlugins(Consumer<List<DataFormatPlugin>> configurer) {
        ArrayList<DataFormatPlugin> plugins = new ArrayList<DataFormatPlugin>(4);
        configurer.accept(plugins);
        this.service = new DataFormatService(plugins);
        return this;
    }

    public MapperBuilder extendPlugins(Consumer<List<DataFormatPlugin>> extender) {
        ArrayList<DataFormatPlugin> plugins = new ArrayList<DataFormatPlugin>(DataFormatService.DEFAULT.getPlugins());
        extender.accept(plugins);
        this.service = new DataFormatService(plugins);
        return this;
    }

    public MapperBuilder withDefaultOutput(MediaType output) {
        this.defaultOutput = output;
        return this;
    }

    public Mapper build() {
        return new Mapper(this.script, this.inputNames, this.imports, this.asFunction, this.libs, this.service, this.defaultOutput);
    }
}

