/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.plugins.DefaultXMLFormatPlugin;
import com.datasonnet.plugins.DefaultXMLFormatPlugin$EffectiveParams$;
import com.datasonnet.plugins.xml.XML$;
import com.datasonnet.spi.AbstractDataFormatPlugin;
import com.datasonnet.spi.PluginException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.ScalaRunTime$;
import ujson.Null$;
import ujson.Obj;
import ujson.Value;

public final class DefaultXMLFormatPlugin$
extends AbstractDataFormatPlugin {
    public static final DefaultXMLFormatPlugin$ MODULE$ = new DefaultXMLFormatPlugin$();
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$XMLNS_KEY = "xmlns";
    private static final String DEFAULT_NS_KEY = "$";
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_NS_SEPARATOR = ":";
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_ATTRIBUTE_KEY_PREFIX = "@";
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_ORDERING_KEY = "~";
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_TEXT_KEY_PREFIX = "$";
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_VERSION = "1.0";
    private static final String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_CDATA_KEY_PREFIX = "#";
    private static final String DEFAULT_DS_MIXED_CONTENT = "both";
    private static final String DS_NS_SEPARATOR = "namespaceseparator";
    private static final String DS_ATTRIBUTE_KEY_PREFIX = "attributecharacter";
    private static final String DS_ORDERING_KEY = "orderingkey";
    private static final String DS_TEXT_KEY_PREFIX = "textvaluekey";
    private static final String DS_CDATA_KEY_PREFIX = "cdatavaluekey";
    private static final String DS_NAMESPACE_DECLARATIONS = "namespacedeclarations\\..*";
    private static final String DS_ROOT_ELEMENT = "rootelement";
    private static final String DS_OMIT_DECLARATION = "omitxmldeclaration";
    private static final String DS_VERSION = "xmlversion";
    private static final String DS_AUTO_EMPTY = "autoemptyelements";
    private static final String DS_NULL_AS_EMPTY = "nullasemptyelement";

    static {
        DefaultXMLFormatPlugin$.MODULE$.supportedTypes.add(MediaTypes.APPLICATION_XML);
        DefaultXMLFormatPlugin$.MODULE$.supportedTypes.add(MediaTypes.TEXT_XML);
        DefaultXMLFormatPlugin$.MODULE$.supportedTypes.add(new MediaType("application", "*+xml"));
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add("indent");
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_NS_SEPARATOR());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_ATTRIBUTE_KEY_PREFIX());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_TEXT_KEY_PREFIX());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_CDATA_KEY_PREFIX());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_ORDERING_KEY());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_NAMESPACE_DECLARATIONS());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_ROOT_ELEMENT());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_OMIT_DECLARATION());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_VERSION());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_AUTO_EMPTY());
        DefaultXMLFormatPlugin$.MODULE$.writerParams.add(MODULE$.DS_NULL_AS_EMPTY());
        DefaultXMLFormatPlugin$.MODULE$.readerParams.add(MODULE$.DS_NS_SEPARATOR());
        DefaultXMLFormatPlugin$.MODULE$.readerParams.add(MODULE$.DS_ATTRIBUTE_KEY_PREFIX());
        DefaultXMLFormatPlugin$.MODULE$.readerParams.add(MODULE$.DS_TEXT_KEY_PREFIX());
        DefaultXMLFormatPlugin$.MODULE$.readerParams.add(MODULE$.DS_CDATA_KEY_PREFIX());
        DefaultXMLFormatPlugin$.MODULE$.readerParams.add(MODULE$.DS_ORDERING_KEY());
        DefaultXMLFormatPlugin$.MODULE$.readerParams.add(MODULE$.DS_NAMESPACE_DECLARATIONS());
        DefaultXMLFormatPlugin$.MODULE$.readerSupportedClasses.add(String.class);
        DefaultXMLFormatPlugin$.MODULE$.readerSupportedClasses.add(URL.class);
        DefaultXMLFormatPlugin$.MODULE$.readerSupportedClasses.add(File.class);
        DefaultXMLFormatPlugin$.MODULE$.readerSupportedClasses.add(InputStream.class);
        DefaultXMLFormatPlugin$.MODULE$.writerSupportedClasses.add(String.class);
        DefaultXMLFormatPlugin$.MODULE$.writerSupportedClasses.add(OutputStream.class);
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$XMLNS_KEY() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$XMLNS_KEY;
    }

    public String DEFAULT_NS_KEY() {
        return DEFAULT_NS_KEY;
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_NS_SEPARATOR() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_NS_SEPARATOR;
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_ATTRIBUTE_KEY_PREFIX() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_ATTRIBUTE_KEY_PREFIX;
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_ORDERING_KEY() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_ORDERING_KEY;
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_TEXT_KEY_PREFIX() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_TEXT_KEY_PREFIX;
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_VERSION() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_VERSION;
    }

    public String com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_CDATA_KEY_PREFIX() {
        return com$datasonnet$plugins$DefaultXMLFormatPlugin$$DEFAULT_DS_CDATA_KEY_PREFIX;
    }

    private String DEFAULT_DS_MIXED_CONTENT() {
        return DEFAULT_DS_MIXED_CONTENT;
    }

    public String DS_NS_SEPARATOR() {
        return DS_NS_SEPARATOR;
    }

    public String DS_ATTRIBUTE_KEY_PREFIX() {
        return DS_ATTRIBUTE_KEY_PREFIX;
    }

    public String DS_ORDERING_KEY() {
        return DS_ORDERING_KEY;
    }

    public String DS_TEXT_KEY_PREFIX() {
        return DS_TEXT_KEY_PREFIX;
    }

    public String DS_CDATA_KEY_PREFIX() {
        return DS_CDATA_KEY_PREFIX;
    }

    public String DS_NAMESPACE_DECLARATIONS() {
        return DS_NAMESPACE_DECLARATIONS;
    }

    public String DS_ROOT_ELEMENT() {
        return DS_ROOT_ELEMENT;
    }

    public String DS_OMIT_DECLARATION() {
        return DS_OMIT_DECLARATION;
    }

    public String DS_VERSION() {
        return DS_VERSION;
    }

    public String DS_AUTO_EMPTY() {
        return DS_AUTO_EMPTY;
    }

    public String DS_NULL_AS_EMPTY() {
        return DS_NULL_AS_EMPTY;
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        DefaultXMLFormatPlugin.EffectiveParams effectiveParams = DefaultXMLFormatPlugin$EffectiveParams$.MODULE$.apply(doc.getMediaType());
        Class<?> clazz = doc.getContent().getClass();
        if (String.class.isAssignableFrom(clazz)) {
            return XML$.MODULE$.loadString((String)doc.getContent(), effectiveParams);
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return XML$.MODULE$.load((URL)doc.getContent(), effectiveParams);
        }
        if (File.class.isAssignableFrom(clazz)) {
            return XML$.MODULE$.loadFile((File)doc.getContent(), effectiveParams);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return XML$.MODULE$.load((InputStream)doc.getContent(), effectiveParams);
        }
        throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canRead before invoking read"));
    }

    @Override
    public <T> Document<T> write(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        if (!(input instanceof Obj)) {
            throw new PluginException(new StringBuilder(44).append("Input for XML writer must be an Object, got ").append(input.getClass()).toString());
        }
        DefaultXMLFormatPlugin.EffectiveParams effectiveParams = DefaultXMLFormatPlugin$EffectiveParams$.MODULE$.apply(mediaType);
        Charset charset = mediaType.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        LinkedHashMap inputAsObj = input.obj();
        if (mediaType.getParameters().containsKey(this.DS_ROOT_ELEMENT())) {
            inputAsObj = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)mediaType.getParameter(this.DS_ROOT_ELEMENT()), (Object)input)}));
        }
        if (inputAsObj.keys().size() > 1) {
            throw new PluginException("Object must have only one root element");
        }
        if (targetType.isAssignableFrom(String.class)) {
            StringWriter writer = new StringWriter();
            XML$.MODULE$.writeXML(writer, (Tuple2<String, Obj>)((Tuple2)inputAsObj.head()), effectiveParams);
            return new DefaultDocument<String>(writer.toString(), MediaTypes.APPLICATION_XML);
        }
        if (targetType.isAssignableFrom(OutputStream.class)) {
            BufferedOutputStream out = new BufferedOutputStream(new ByteArrayOutputStream());
            XML$.MODULE$.writeXML(new OutputStreamWriter((OutputStream)out, charset), (Tuple2<String, Obj>)((Tuple2)inputAsObj.head()), effectiveParams);
            return new DefaultDocument<BufferedOutputStream>(out, MediaTypes.APPLICATION_XML);
        }
        throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canRead before invoking read"));
    }

    private DefaultXMLFormatPlugin$() {
    }
}

