/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.data.CollectionRepository;
import io.stargate.sdk.data.domain.DocumentMutationResult;
import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.data.domain.odm.DocumentResult;
import io.stargate.sdk.data.domain.query.DeleteQuery;
import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.SelectQuery;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class AstraDBRepository<DOC> {
    CollectionRepository<DOC> collectionRepository;

    AstraDBRepository(CollectionRepository<DOC> collectionRepository) {
        this.collectionRepository = collectionRepository;
    }

    public boolean exists(String id) {
        return this.collectionRepository.exists(id);
    }

    public DocumentMutationResult<DOC> insert(Document<DOC> bean) {
        return this.collectionRepository.insert(bean);
    }

    public CompletableFuture<DocumentMutationResult<DOC>> insertAsync(Document<DOC> bean) {
        return this.collectionRepository.insertASync(bean);
    }

    public final List<DocumentMutationResult<DOC>> insert(List<Document<DOC>> documents) {
        return this.collectionRepository.insert(documents);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> insertASync(List<Document<DOC>> documents) {
        return this.collectionRepository.insertASync(documents);
    }

    public final List<DocumentMutationResult<DOC>> insert(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionRepository.insert(documents, chunkSize, concurrency);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> insertASync(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionRepository.insertASync(documents, chunkSize, concurrency);
    }

    public final DocumentMutationResult<DOC> save(@NonNull Document<DOC> current) {
        if (current == null) {
            throw new NullPointerException("current is marked non-null but is null");
        }
        return this.collectionRepository.save(current);
    }

    public final CompletableFuture<DocumentMutationResult<DOC>> saveASync(@NonNull Document<DOC> current) {
        if (current == null) {
            throw new NullPointerException("current is marked non-null but is null");
        }
        return this.collectionRepository.saveASync(current);
    }

    public final List<DocumentMutationResult<DOC>> saveAll(List<Document<DOC>> documentList) {
        return this.collectionRepository.saveAll(documentList);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> saveAllASync(List<Document<DOC>> documentList) {
        return this.collectionRepository.saveAllASync(documentList);
    }

    public final List<DocumentMutationResult<DOC>> saveAll(List<Document<DOC>> documentList, int chunkSize, int concurrency) {
        return this.collectionRepository.saveAll(documentList, chunkSize, concurrency);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> saveAllASync(List<Document<DOC>> documentList, int chunkSize, int concurrency) {
        return this.collectionRepository.saveAllASync(documentList, chunkSize, concurrency);
    }

    public final int count() {
        return this.count(null);
    }

    public final int count(Filter jsonFilter) {
        return this.collectionRepository.count(jsonFilter);
    }

    public Optional<DocumentResult<DOC>> findById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.collectionRepository.findById(id);
    }

    public Stream<DocumentResult<DOC>> findAll() {
        return this.collectionRepository.search();
    }

    public Stream<DocumentResult<DOC>> find(@NonNull SelectQuery query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.collectionRepository.search(query);
    }

    public Page<DocumentResult<DOC>> searchPage(SelectQuery query) {
        return this.collectionRepository.searchPage(query);
    }

    public boolean delete(Document<DOC> document) {
        return this.collectionRepository.delete(document);
    }

    public int deleteAll() {
        return this.collectionRepository.deleteAll();
    }

    public int deleteAll(List<Document<DOC>> documents) {
        List futures = documents.stream().map(record -> CompletableFuture.supplyAsync(() -> this.delete((Document<DOC>)record) ? 1 : 0)).collect(Collectors.toList());
        return futures.stream().map(CompletableFuture::join).mapToInt(Integer::intValue).sum();
    }

    public int deleteAll(DeleteQuery deleteQuery) {
        return this.collectionRepository.deleteAll(deleteQuery);
    }

    public Optional<DocumentResult<DOC>> findByVector(float[] vector) {
        return this.collectionRepository.findByVector(vector);
    }

    public boolean deleteByVector(float[] vector) {
        return this.collectionRepository.deleteByVector(vector);
    }

    public boolean deleteById(String id) {
        return this.collectionRepository.deleteById(id);
    }

    public Page<DocumentResult<DOC>> findVector(float[] vector, Filter metadataFilter) {
        return this.collectionRepository.findVector(vector, metadataFilter);
    }

    public List<DocumentResult<DOC>> findVector(float[] vector, Integer limit) {
        return this.collectionRepository.findVector(vector, limit);
    }

    public List<DocumentResult<DOC>> findVector(float[] vector, Filter metadataFilter, Integer limit) {
        return this.collectionRepository.findVector(vector, metadataFilter, limit);
    }

    public CollectionRepository<DOC> getCollectionRepository() {
        return this.collectionRepository;
    }
}

