/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.streaming.domain.Statistics;
import com.dtsx.astra.sdk.streaming.domain.Tenant;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.HttpClientWrapper;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class TenantStatsClient
extends AbstractApiClient {
    private static final TypeReference<Map<String, Statistics>> TYPE_LIST_STATISTICS = new TypeReference<Map<String, Statistics>>(){};
    private final Tenant tenant;

    public TenantStatsClient(String token, String tenantId) {
        this(token, AstraEnvironment.PROD, tenantId);
    }

    public TenantStatsClient(String token, AstraEnvironment env, String tenantId) {
        super(token, env);
        Assert.hasLength(tenantId, "tenantId");
        this.tenant = new AstraStreamingClient(token, env).get(tenantId);
    }

    public Stream<Statistics> namespaces() {
        return JsonUtils.unmarshallType(HttpClientWrapper.getInstance().GET_PULSAR(this.getEndpointStatisticsNamespaces(), this.tenant.getPulsarToken(), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString()).getBody(), TYPE_LIST_STATISTICS).values().stream();
    }

    public Optional<Statistics> namespace(String namespace) {
        Map<String, Statistics> map = JsonUtils.unmarshallType(HttpClientWrapper.getInstance().GET_PULSAR(this.getEndpointStatisticsNamespaces() + "/" + namespace, this.tenant.getPulsarToken(), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString()).getBody(), TYPE_LIST_STATISTICS);
        return Optional.ofNullable(map.get(this.tenant.getTenantName() + "/" + namespace));
    }

    public Stream<Statistics> topics() {
        return JsonUtils.unmarshallType(HttpClientWrapper.getInstance().GET_PULSAR(this.getEndpointStatisticsTopics(), this.tenant.getPulsarToken(), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString()).getBody(), TYPE_LIST_STATISTICS).values().stream();
    }

    public Stream<Statistics> topics(String namespace) {
        return JsonUtils.unmarshallType(HttpClientWrapper.getInstance().GET_PULSAR(this.getEndpointStatisticsTopics() + "/" + namespace, this.tenant.getPulsarToken(), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString()).getBody(), TYPE_LIST_STATISTICS).values().stream();
    }

    public String getEndpointStreamingAdminV2() {
        return ApiLocator.getApiStreamingV2Endpoint(this.environment, this.tenant.getClusterName());
    }

    public String getEndpointStatisticsNamespaces() {
        return this.getEndpointStreamingAdminV2() + "/stats/namespaces/" + this.tenant.getTenantName();
    }

    public String getEndpointStatisticsTopics() {
        return this.getEndpointStreamingAdminV2() + "/stats/topics/" + this.tenant.getTenantName();
    }
}

