/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;

class Requests {
    private Requests() {
    }

    public static class AuthResponse
    extends Message.Request {
        public static final Message.Coder<AuthResponse> coder = new Message.Coder<AuthResponse>(){

            @Override
            public void encode(AuthResponse response, ChannelBuffer dest) {
                CBUtil.writeValue(response.token, dest);
            }

            @Override
            public int encodedSize(AuthResponse response) {
                return CBUtil.sizeOfValue(response.token);
            }
        };
        private final byte[] token;

        public AuthResponse(byte[] token) {
            super(Message.Request.Type.AUTH_RESPONSE);
            this.token = token;
        }
    }

    public static class Register
    extends Message.Request {
        public static final Message.Coder<Register> coder = new Message.Coder<Register>(){

            @Override
            public void encode(Register msg, ChannelBuffer dest) {
                dest.writeShort(msg.eventTypes.size());
                for (ProtocolEvent.Type type : msg.eventTypes) {
                    CBUtil.writeEnumValue(type, dest);
                }
            }

            @Override
            public int encodedSize(Register msg) {
                int size = 2;
                for (ProtocolEvent.Type type : msg.eventTypes) {
                    size += CBUtil.sizeOfEnumValue(type);
                }
                return size;
            }
        };
        private final List<ProtocolEvent.Type> eventTypes;

        public Register(List<ProtocolEvent.Type> eventTypes) {
            super(Message.Request.Type.REGISTER);
            this.eventTypes = eventTypes;
        }

        public String toString() {
            return "REGISTER " + this.eventTypes;
        }
    }

    public static class Prepare
    extends Message.Request {
        public static final Message.Coder<Prepare> coder = new Message.Coder<Prepare>(){

            @Override
            public void encode(Prepare msg, ChannelBuffer dest) {
                CBUtil.writeLongString(msg.query, dest);
            }

            @Override
            public int encodedSize(Prepare msg) {
                return CBUtil.sizeOfLongString(msg.query);
            }
        };
        private final String query;

        public Prepare(String query) {
            super(Message.Request.Type.PREPARE);
            this.query = query;
        }

        public String toString() {
            return "PREPARE " + this.query;
        }
    }

    public static class Batch
    extends Message.Request {
        public static final Message.Coder<Batch> coder = new Message.Coder<Batch>(){

            @Override
            public void encode(Batch msg, ChannelBuffer dest) {
                int queries = msg.queryOrIdList.size();
                assert (queries <= 65535);
                dest.writeByte((int)this.fromType(msg.type));
                dest.writeShort(queries);
                for (int i = 0; i < queries; ++i) {
                    Object q = msg.queryOrIdList.get(i);
                    dest.writeByte((int)((byte)(!(q instanceof String) ? 1 : 0)));
                    if (q instanceof String) {
                        CBUtil.writeLongString((String)q, dest);
                    } else {
                        CBUtil.writeBytes(((MD5Digest)q).bytes, dest);
                    }
                    CBUtil.writeValueList(msg.values.get(i), dest);
                }
                CBUtil.writeConsistencyLevel(msg.consistency, dest);
            }

            @Override
            public int encodedSize(Batch msg) {
                int size = 3;
                for (int i = 0; i < msg.queryOrIdList.size(); ++i) {
                    Object q = msg.queryOrIdList.get(i);
                    size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfBytes(((MD5Digest)q).bytes));
                    size += CBUtil.sizeOfValueList(msg.values.get(i));
                }
                return size += CBUtil.sizeOfConsistencyLevel(msg.consistency);
            }

            private byte fromType(BatchStatement.Type type) {
                switch (type) {
                    case LOGGED: {
                        return 0;
                    }
                    case UNLOGGED: {
                        return 1;
                    }
                    case COUNTER: {
                        return 2;
                    }
                }
                throw new AssertionError();
            }
        };
        public final BatchStatement.Type type;
        public final List<Object> queryOrIdList;
        public final List<List<ByteBuffer>> values;
        public final ConsistencyLevel consistency;

        public Batch(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, ConsistencyLevel consistency) {
            super(Message.Request.Type.BATCH);
            this.type = type;
            this.queryOrIdList = queryOrIdList;
            this.values = values;
            this.consistency = consistency;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BATCH of [");
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
            }
            sb.append("] at consistency ").append((Object)this.consistency);
            return sb.toString();
        }
    }

    public static class QueryProtocolOptions {
        public static final QueryProtocolOptions DEFAULT = new QueryProtocolOptions(ConsistencyLevel.ONE, Collections.<ByteBuffer>emptyList(), false, -1, null, ConsistencyLevel.SERIAL);
        private final EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        public final ConsistencyLevel consistency;
        public final List<ByteBuffer> values;
        public final boolean skipMetadata;
        public final int pageSize;
        public final ByteBuffer pagingState;
        public final ConsistencyLevel serialConsistency;

        public QueryProtocolOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, ByteBuffer pagingState, ConsistencyLevel serialConsistency) {
            this.consistency = consistency;
            this.values = values;
            this.skipMetadata = skipMetadata;
            this.pageSize = pageSize;
            this.pagingState = pagingState;
            this.serialConsistency = serialConsistency;
            if (!values.isEmpty()) {
                this.flags.add(Flag.VALUES);
            }
            if (skipMetadata) {
                this.flags.add(Flag.SKIP_METADATA);
            }
            if (pageSize >= 0) {
                this.flags.add(Flag.PAGE_SIZE);
            }
            if (pagingState != null) {
                this.flags.add(Flag.PAGING_STATE);
            }
            if (serialConsistency != ConsistencyLevel.SERIAL) {
                this.flags.add(Flag.SERIAL_CONSISTENCY);
            }
        }

        public void encode(ChannelBuffer dest) {
            CBUtil.writeConsistencyLevel(this.consistency, dest);
            dest.writeByte((int)((byte)Flag.serialize(this.flags)));
            if (this.flags.contains((Object)Flag.VALUES)) {
                CBUtil.writeValueList(this.values, dest);
            }
            if (this.flags.contains((Object)Flag.PAGE_SIZE)) {
                dest.writeInt(this.pageSize);
            }
            if (this.flags.contains((Object)Flag.PAGING_STATE)) {
                CBUtil.writeValue(this.pagingState, dest);
            }
            if (this.flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                CBUtil.writeConsistencyLevel(this.serialConsistency, dest);
            }
        }

        public int encodedSize() {
            int size = CBUtil.sizeOfConsistencyLevel(this.consistency) + 1;
            if (this.flags.contains((Object)Flag.VALUES)) {
                size += CBUtil.sizeOfValueList(this.values);
            }
            if (this.flags.contains((Object)Flag.PAGE_SIZE)) {
                size += 4;
            }
            if (this.flags.contains((Object)Flag.PAGING_STATE)) {
                size += CBUtil.sizeOfValue(this.pagingState);
            }
            if (this.flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                size += CBUtil.sizeOfConsistencyLevel(this.serialConsistency);
            }
            return size;
        }

        public String toString() {
            return String.format("[cl=%s, vals=%s, skip=%b, psize=%d, state=%s, serialCl=%s]", new Object[]{this.consistency, this.values, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency});
        }

        private static enum Flag {
            VALUES,
            SKIP_METADATA,
            PAGE_SIZE,
            PAGING_STATE,
            SERIAL_CONSISTENCY;


            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < values.length; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }

    public static class Execute
    extends Message.Request {
        public static final Message.Coder<Execute> coderV1 = new Message.Coder<Execute>(){

            @Override
            public void encode(Execute msg, ChannelBuffer dest) {
                CBUtil.writeBytes(msg.statementId.bytes, dest);
                CBUtil.writeValueList(msg.options.values, dest);
                CBUtil.writeConsistencyLevel(msg.options.consistency, dest);
            }

            @Override
            public int encodedSize(Execute msg) {
                return CBUtil.sizeOfBytes(msg.statementId.bytes) + CBUtil.sizeOfValueList(msg.options.values) + CBUtil.sizeOfConsistencyLevel(msg.options.consistency);
            }
        };
        public static final Message.Coder<Execute> coderV2 = new Message.Coder<Execute>(){

            @Override
            public void encode(Execute msg, ChannelBuffer dest) {
                CBUtil.writeBytes(msg.statementId.bytes, dest);
                msg.options.encode(dest);
            }

            @Override
            public int encodedSize(Execute msg) {
                return CBUtil.sizeOfBytes(msg.statementId.bytes) + msg.options.encodedSize();
            }
        };
        public final MD5Digest statementId;
        public final QueryProtocolOptions options;

        public Execute(MD5Digest statementId, QueryProtocolOptions options) {
            super(Message.Request.Type.EXECUTE);
            this.statementId = statementId;
            this.options = options;
        }

        public String toString() {
            return "EXECUTE " + this.statementId + " (" + this.options + ')';
        }
    }

    public static class Query
    extends Message.Request {
        public static final Message.Coder<Query> coderV1 = new Message.Coder<Query>(){

            @Override
            public void encode(Query msg, ChannelBuffer dest) {
                CBUtil.writeLongString(msg.query, dest);
                CBUtil.writeConsistencyLevel(msg.options.consistency, dest);
            }

            @Override
            public int encodedSize(Query msg) {
                return CBUtil.sizeOfLongString(msg.query) + CBUtil.sizeOfConsistencyLevel(msg.options.consistency);
            }
        };
        public static final Message.Coder<Query> coderV2 = new Message.Coder<Query>(){

            @Override
            public void encode(Query msg, ChannelBuffer dest) {
                CBUtil.writeLongString(msg.query, dest);
                msg.options.encode(dest);
            }

            @Override
            public int encodedSize(Query msg) {
                return CBUtil.sizeOfLongString(msg.query) + msg.options.encodedSize();
            }
        };
        public final String query;
        public final QueryProtocolOptions options;

        public Query(String query) {
            this(query, QueryProtocolOptions.DEFAULT);
        }

        public Query(String query, QueryProtocolOptions options) {
            super(Message.Request.Type.QUERY);
            this.query = query;
            this.options = options;
        }

        public String toString() {
            return "QUERY " + this.query + '(' + this.options + ')';
        }
    }

    public static class Options
    extends Message.Request {
        public static final Message.Coder<Options> coder = new Message.Coder<Options>(){

            @Override
            public void encode(Options msg, ChannelBuffer dest) {
            }

            @Override
            public int encodedSize(Options msg) {
                return 0;
            }
        };

        public Options() {
            super(Message.Request.Type.OPTIONS);
        }

        public String toString() {
            return "OPTIONS";
        }
    }

    public static class Credentials
    extends Message.Request {
        public static final Message.Coder<Credentials> coder = new Message.Coder<Credentials>(){

            @Override
            public void encode(Credentials msg, ChannelBuffer dest) {
                CBUtil.writeStringMap(msg.credentials, dest);
            }

            @Override
            public int encodedSize(Credentials msg) {
                return CBUtil.sizeOfStringMap(msg.credentials);
            }
        };
        private final Map<String, String> credentials;

        public Credentials(Map<String, String> credentials) {
            super(Message.Request.Type.CREDENTIALS);
            this.credentials = credentials;
        }
    }

    public static class Startup
    extends Message.Request {
        private static final String CQL_VERSION_OPTION = "CQL_VERSION";
        private static final String CQL_VERSION = "3.0.0";
        public static final String COMPRESSION_OPTION = "COMPRESSION";
        public static final Message.Coder<Startup> coder = new Message.Coder<Startup>(){

            @Override
            public void encode(Startup msg, ChannelBuffer dest) {
                CBUtil.writeStringMap(msg.options, dest);
            }

            @Override
            public int encodedSize(Startup msg) {
                return CBUtil.sizeOfStringMap(msg.options);
            }
        };
        private final Map<String, String> options;

        public Startup(ProtocolOptions.Compression compression) {
            super(Message.Request.Type.STARTUP);
            ImmutableMap.Builder map = new ImmutableMap.Builder();
            map.put((Object)CQL_VERSION_OPTION, (Object)CQL_VERSION);
            if (compression != ProtocolOptions.Compression.NONE) {
                map.put((Object)COMPRESSION_OPTION, (Object)compression.toString());
            }
            this.options = map.build();
        }

        public String toString() {
            return "STARTUP " + this.options;
        }
    }
}

