/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.jdk8;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.ZoneId;

@IgnoreJDK6Requirement
public class ZoneIdCodec
extends TypeCodec<ZoneId> {
    public static final ZoneIdCodec instance = new ZoneIdCodec();

    private ZoneIdCodec() {
        super(DataType.varchar(), ZoneId.class);
    }

    public ByteBuffer serialize(ZoneId value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ZoneIdCodec.varchar().serialize((Object)value.toString(), protocolVersion);
    }

    public ZoneId deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        return ZoneId.of((String)ZoneIdCodec.varchar().deserialize(bytes, protocolVersion));
    }

    public String format(ZoneId value) {
        if (value == null) {
            return "NULL";
        }
        return ZoneIdCodec.varchar().format((Object)value.toString());
    }

    public ZoneId parse(String value) {
        String parsed = (String)ZoneIdCodec.varchar().parse(value);
        if (parsed == null || parsed.isEmpty() || parsed.equalsIgnoreCase("NULL")) {
            return null;
        }
        try {
            return ZoneId.of(parsed);
        }
        catch (DateTimeException e) {
            String msg = String.format("Cannot parse zone-ID value from \"%s\"", value);
            throw new InvalidTypeException(msg);
        }
    }
}

