/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import io.stargate.sdk.ManagedServiceDatacenter;
import io.stargate.sdk.Service;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.loadbalancer.LoadBalancedResource;
import io.stargate.sdk.loadbalancer.NoneResourceAvailableException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServiceDeployment<SERVICE extends Service> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedServiceDeployment.class);
    private final Map<String, ManagedServiceDatacenter<SERVICE>> datacenters = new HashMap<String, ManagedServiceDatacenter<SERVICE>>();
    private String currentDatacenter;

    public ManagedServiceDeployment(ServiceDeployment<SERVICE> sDeploy) {
        if (sDeploy != null) {
            sDeploy.getDatacenters().values().stream().map(ManagedServiceDatacenter::new).forEach(mdc -> this.datacenters.put(mdc.getDatacenterName(), (ManagedServiceDatacenter<SERVICE>)mdc));
            this.currentDatacenter = sDeploy.getLocalDc();
        }
        if (this.currentDatacenter == null) {
            this.currentDatacenter = this.datacenters.keySet().iterator().next();
        }
    }

    public void useDataCenter(String datacenter) {
        if (!this.getDatacenters().containsKey(datacenter)) {
            throw new IllegalArgumentException("'" + datacenter + "' is not a known datacenter please provides one in " + String.valueOf(this.getDatacenters().keySet()));
        }
        LOGGER.info("Using DataCenter [" + datacenter + "]");
        this.currentDatacenter = datacenter;
    }

    public ManagedServiceDatacenter<SERVICE> getLocalDatacenterClient() {
        if (!this.datacenters.containsKey(this.currentDatacenter)) {
            throw new IllegalStateException("Cannot retrieve datacenter [" + this.currentDatacenter + "] from definition, check cluster topology");
        }
        return this.datacenters.get(this.currentDatacenter);
    }

    public String lookupToken() {
        if (this.getLocalDatacenterClient() == null) {
            throw new IllegalStateException("There is not local datacenter please check initialization");
        }
        if (this.getLocalDatacenterClient().getTokenProvider() == null) {
            throw new IllegalStateException("There is not token provider for dc '" + String.valueOf(this.getLocalDatacenterClient()) + "' please check initialization");
        }
        return this.getLocalDatacenterClient().getTokenProvider().getToken();
    }

    public LoadBalancedResource<SERVICE> lookupStargateNode() {
        return this.getLocalDatacenterClient().getStargateNodesLB().getLoadBalancedResource();
    }

    public void failOverDatacenter() {
        this.getDatacenters().get(this.currentDatacenter).setAvailable(false);
        Set<String> availableDc = this.getAvailableDatacenters();
        if (availableDc.size() == 0) {
            throw new NoneResourceAvailableException("No Resource available anymore on ");
        }
        String newDc = availableDc.iterator().next();
        LOGGER.info("Fail-over from {} to {}", (Object)this.currentDatacenter, (Object)newDc);
        this.useDataCenter(newDc);
    }

    public void failOverStargateNode(LoadBalancedResource<SERVICE> lb, Throwable t) {
        this.getLocalDatacenterClient().getStargateNodesLB().handleComponentError(lb, t);
    }

    public Map<String, ManagedServiceDatacenter<SERVICE>> getDatacenters() {
        return this.datacenters;
    }

    public Set<String> getUnavailableDatacenters() {
        return this.datacenters.values().stream().filter(ManagedServiceDatacenter::isNotAvailable).map(ManagedServiceDatacenter::getDatacenterName).collect(Collectors.toSet());
    }

    public Set<String> getAvailableDatacenters() {
        return this.datacenters.values().stream().filter(ManagedServiceDatacenter::isAvailable).map(ManagedServiceDatacenter::getDatacenterName).collect(Collectors.toSet());
    }

    public String toString() {
        return "ManagedServiceDeployment{datacenters=" + String.valueOf(this.datacenters) + ", currentDatacenter='" + this.currentDatacenter + "'}";
    }
}

