/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.spring.EditorController;
import com.baidu.ueditor.upload.StorageManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BinaryUploader {
    public static State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
            Collection files = mRequest.getFileMap().values();
            if (files.size() == 0) {
                return new BaseState(false, 7);
            }
            MultipartFile file = (MultipartFile)files.iterator().next();
            String originFileName = file.getOriginalFilename();
            assert (originFileName != null);
            String suffix = FileType.getSuffixByFilename(originFileName);
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            long maxSize = (Long)conf.get("maxSize");
            if (maxSize < file.getSize()) {
                return new BaseState(false, 1);
            }
            String savePath = (String)conf.get("savePath");
            savePath = savePath + suffix;
            savePath = PathFormat.parse(savePath, originFileName);
            String physicalPath = PathFormat.format(EditorController.properties.getLocal().getPhysicalPath() + "/" + savePath);
            State storageState = StorageManager.saveFileByInputStream(file.getInputStream(), physicalPath);
            if (storageState.isSuccess()) {
                storageState.putInfo("url", PathFormat.format(conf.get("contextPath") + "/" + EditorController.properties.getLocal().getUrlPrefix() + "/" + PathFormat.format(savePath)));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName);
            }
            return storageState;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

