/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.common.exception;

import com.definesys.mpaas.common.exception.MpaasBusinessException;
import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.common.http.Response;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class MpaasExceptionHandler
extends ResponseEntityExceptionHandler {
    @Autowired
    private MpaasQueryConfig config;
    public static final String DEV = "DEV";
    public static final String PROD = "PROD";

    @ExceptionHandler(value={MpaasRuntimeException.class})
    protected ResponseEntity<Object> handleRuntimeException(RuntimeException ex, WebRequest request) {
        ex.printStackTrace();
        String msg = this.config.humanMessage;
        if (DEV.equalsIgnoreCase(this.config.runMode)) {
            msg = MpaasUtil.strEmpty(ex.getMessage()) ? MpaasUtil.getThrowableDetail(ex) : ex.getMessage();
        }
        return this.handleExceptionInternal(ex, Response.error(msg), new HttpHeaders(), HttpStatus.INTERNAL_SERVER_ERROR, request);
    }

    @ExceptionHandler(value={MpaasBusinessException.class})
    protected ResponseEntity<Object> handleBusinessException(RuntimeException ex, WebRequest request) {
        return this.handleExceptionInternal(ex, Response.error(ex.getMessage()), new HttpHeaders(), HttpStatus.OK, request);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleException(RuntimeException ex, WebRequest request) {
        ex.printStackTrace();
        String msg = this.config.humanMessage;
        if (DEV.equalsIgnoreCase(this.config.runMode)) {
            msg = MpaasUtil.getThrowableDetail(ex);
        }
        return this.handleExceptionInternal(ex, Response.error(msg), new HttpHeaders(), HttpStatus.INTERNAL_SERVER_ERROR, request);
    }
}

