/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.common.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.UUID;

public class MpaasUtil {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.definesys.mpaas.log.messages.Messages");

    public static String getThrowableDetail(Throwable s) {
        String NEW_LINE = System.getProperty("line.separator");
        if (s == null) {
            return NEW_LINE;
        }
        StringBuffer result = new StringBuffer();
        result.append(s.toString());
        result.append(NEW_LINE);
        for (StackTraceElement element : s.getStackTrace()) {
            result.append(element);
            result.append(NEW_LINE);
        }
        result.append("Caused by:");
        result.append(NEW_LINE);
        result.append(s.getCause());
        return result.toString();
    }

    public static boolean strEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String getResourceMessage(String code, Object ... params) {
        String pattern = resourceBundle.getString(code);
        MessageFormat mf = new MessageFormat(pattern);
        return mf.format(params, new StringBuffer(128), (FieldPosition)null).toString();
    }

    public static String guuid() {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }

    public static String generateUniqueKey() {
        return MpaasUtil.guuid();
    }
}

