/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.MpaasQuery;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DatabaseAdapterFactory;
import com.definesys.mpaas.query.db.DatasourceContainer;
import com.definesys.mpaas.query.db.Dialect;
import com.definesys.mpaas.query.db.DialectFactory;
import com.definesys.mpaas.query.db.StorageDatasource;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MapperScan(value={"com.definesys.mpaas.mybatis.mapper"})
public class MpaasQueryFactory {
    @Autowired
    private DialectFactory dialectFactory;
    @Autowired
    private DatabaseAdapterFactory databaseAdapterFactory;
    @Autowired
    private MpaasQueryConfig config;
    @Autowired
    private SWordLogger logger;
    @Autowired
    private DatasourceContainer datasourceContainer;

    @Autowired
    public MpaasQueryFactory(DialectFactory dialectFactory) {
        this.dialectFactory = dialectFactory;
    }

    public MpaasQuery buildQuery(StorageDatasource dataSource, String type) {
        DatabaseAdapter database = this.databaseAdapterFactory.buildMultiDatasourceAdapter(type);
        database.dataSource(dataSource);
        MpaasQuery mpaasQuery = new MpaasQuery(this.dialectFactory.buildMultiDatabaseDialect(type), database, this.config, this.logger);
        return mpaasQuery;
    }

    public MpaasQuery buildFromDatasource(String name) {
        StorageDatasource ds = this.datasourceContainer.findDatasource(name);
        if (ds == null) {
            throw new MpaasRuntimeException("can not find datasource %s", name);
        }
        return this.buildFromDatasource(ds);
    }

    public MpaasQuery buildFromDatasource(StorageDatasource datasource) {
        return this.buildQuery(datasource, datasource.getType());
    }

    public MpaasQuery buildQuery() {
        return this.buildQuery(null, null, null);
    }

    public MpaasQuery buildQuery(Object pojo) {
        return this.buildQuery(pojo, null, null);
    }

    public MpaasQuery buildQuery(Class clazz) {
        return this.buildQuery(null, clazz, null);
    }

    private MpaasQuery buildQuery(Object pojo, Class clazz, String view) {
        Dialect dialect = this.dialectFactory.buildDatabaseDialect();
        MpaasQuery mpaasQuery = new MpaasQuery(dialect, this.databaseAdapterFactory.buildDatabaseAdapter(), this.config, this.logger);
        mpaasQuery.pageSize(this.config.PAGE_SIZE);
        mpaasQuery.view(view);
        if (view != null) {
            mpaasQuery.viewQueryMode(true);
        }
        if (pojo != null) {
            mpaasQuery.bind(clazz);
        }
        if (clazz != null) {
            mpaasQuery.bind(clazz);
        }
        return mpaasQuery;
    }

    public MpaasQuery buildViewQuery() {
        return this.buildQuery(null, null, null).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Object pojo) {
        return this.buildQuery(pojo, pojo.getClass(), null).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Class clazz) {
        return this.buildQuery(null, clazz, null).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(String view) {
        return this.buildQuery(null, null, view).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Object pojo, String view) {
        return this.buildQuery(pojo, pojo.getClass(), view).viewQueryMode(true);
    }

    public MpaasQuery buildViewQuery(Class clazz, String view) {
        return this.buildQuery(null, clazz, view).viewQueryMode(true);
    }
}

