/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.conf;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.sql2o.Sql2o;

@Configuration
public class DatabaseContext {
    @Autowired
    private MpaasQueryConfig config;

    @Bean
    public ServletRegistrationBean druidStatViewServletBean() {
        ServletRegistrationBean statViewServletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("loginUsername", this.config.druidAdmin);
        params.put("loginPassword", this.config.druidPassword);
        params.put("resetEnable", "true");
        statViewServletRegistrationBean.setInitParameters(params);
        return statViewServletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean druidStatFilterBean() {
        FilterRegistrationBean druidStatFilterBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        ArrayList<String> urlPattern = new ArrayList<String>();
        urlPattern.add("/*");
        druidStatFilterBean.setUrlPatterns(urlPattern);
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("exclusions", "*.js,*.gif,*.jpg,*.bmp,*.png,*.css,*.ico,/druid/*");
        druidStatFilterBean.setInitParameters(initParams);
        return druidStatFilterBean;
    }

    @Bean
    public DataSource dataSource() {
        if (this.config.isSqlDatabase()) {
            if (!"none".equalsIgnoreCase(this.config.dbJndi)) {
                JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
                bean.setJndiName(this.config.dbJndi);
                bean.setProxyInterface(DataSource.class);
                bean.setLookupOnStartup(false);
                try {
                    bean.afterPropertiesSet();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
                return (DataSource)bean.getObject();
            }
            DruidDataSource datasource = new DruidDataSource();
            datasource.setUrl(this.config.dbUrl);
            datasource.setUsername(this.config.dbUsername);
            datasource.setPassword(this.config.dbPassword);
            datasource.setDriverClassName(this.config.dbDriverClassName);
            datasource.setInitialSize(this.config.dbInitialSize);
            datasource.setMaxActive(this.config.dbMaxActive);
            if (this.config.dbPoolPreparedStatements != null) {
                datasource.setPoolPreparedStatements(this.config.dbPoolPreparedStatements.booleanValue());
            }
            if (this.config.dbMaxWait != -1) {
                datasource.setMaxWait((long)this.config.dbMaxWait);
            }
            if (!MpaasUtil.strEmpty(this.config.dbConnectionProperties)) {
                datasource.setConnectProperties(this.string2Properties(this.config.dbConnectionProperties));
            }
            if (this.config.dbUseGlobalDataSourceStat != null) {
                datasource.setUseGlobalDataSourceStat(this.config.dbUseGlobalDataSourceStat.booleanValue());
            }
            if (!MpaasUtil.strEmpty(this.config.dbFilters)) {
                try {
                    datasource.setFilters(this.config.dbFilters);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return datasource;
        }
        return new DruidDataSource();
    }

    @Bean
    @Autowired
    public Sql2o sql2o(DataSource dataSource) {
        if (!"nosql".equals(this.config.DB_ADAPTER)) {
            return new Sql2o(dataSource);
        }
        return null;
    }

    private Properties string2Properties(String str) {
        str = str.replaceAll(";", "\r\n");
        Properties properties = new Properties();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        try {
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }
}

