/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.filter;

import com.definesys.mpaas.common.adapter.IMpaasSSOAuthentication;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.security.SecurityGate;
import com.definesys.mpaas.query.util.ContextWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class J2EEServletFilter
implements Filter {
    private String userHeaderName;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.userHeaderName = filterConfig.getInitParameter("userHeaderName");
        if (this.userHeaderName == null) {
            this.userHeaderName = "uid";
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String uri;
        boolean bok;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        MpaasQueryConfig config = ContextWrapper.getMpassConfig();
        SecurityGate gate = new SecurityGate(config, (IMpaasSSOAuthentication)ContextWrapper.getContext().getBean(IMpaasSSOAuthentication.class));
        if ("OPTIONS".equals(request.getMethod())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean bAuth = gate.auth(request, !config.useSecurity);
        if (config.useSecurity && !bAuth && !(bok = gate.validateURISecurity(uri = request.getRequestURI()))) {
            gate.unAuthorized(servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

