/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.filter;

import com.definesys.mpaas.common.adapter.IMpaasSSOAuthentication;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.security.SecurityGate;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MpaasFilter
implements Filter {
    @Autowired(required=false)
    private IMpaasSSOAuthentication ssoAuthentication;
    @Autowired
    private MpaasQueryConfig config;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String uri;
        boolean bok;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        SecurityGate gate = new SecurityGate(this.config, this.ssoAuthentication);
        if ("OPTIONS".equals(request.getMethod())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean bAuth = gate.auth(request, !this.config.useSecurity);
        if (this.config.useSecurity && !bAuth && !(bok = gate.validateURISecurity(uri = request.getRequestURI()))) {
            gate.unAuthorized(servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

