/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.lookup;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.lookup.CacheParam;
import com.definesys.mpaas.query.lookup.LookupCache;
import com.definesys.mpaas.query.lookup.LookupInfo;
import com.definesys.mpaas.query.util.MD5Util;
import com.definesys.mpaas.query.util.TypeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LookupHandler<T> {
    public static final Pattern VAR_PT = Pattern.compile("#([\\w|\\d|_]+)", 34);
    private PojoMeta meta;
    private List<T> data;
    private DatabaseAdapter adapter;
    private List<LookupInfo> lookups;
    private LookupInfo currentLookup;
    private static LookupCache lookupCache = new LookupCache();

    public LookupHandler(PojoMeta meta, List<T> data, DatabaseAdapter adapter) {
        if (meta == null) {
            return;
        }
        this.lookups = meta.getLookups();
        if (this.lookups == null) {
            return;
        }
        this.meta = meta;
        this.data = data;
        this.adapter = adapter;
    }

    public void execute() {
        if (this.lookups == null) {
            return;
        }
        Iterator<LookupInfo> iterator = this.lookups.iterator();
        while (iterator.hasNext()) {
            LookupInfo lookup;
            this.currentLookup = lookup = iterator.next();
            this.execute(lookup);
        }
    }

    private void execute(LookupInfo lookup) {
        if (lookup == null) {
            return;
        }
        if (lookup.getSql() != null) {
            this.executeSQL(lookup.getSql());
        } else if (lookup.getView() != null) {
            this.executeSQL(this.meta.findViewSQL(lookup.getView()));
        } else {
            this.executeSQL(this.buildQuerySQL(lookup.getFrom(), lookup.getTo(), lookup.getTable(), lookup.getWhere()));
        }
    }

    private String buildQuerySQL(String from, String to, String table, String where) {
        this.validate(from, to, table, where);
        from = from == null ? to : from;
        to = to == null ? from : to;
        StringBuffer sql = new StringBuffer();
        if (from.equals(to)) {
            sql.append(String.format("select %s from %s where %s", from, table, where));
        } else {
            String[] s2;
            String[] s1 = from.split(",");
            if (s1.length != (s2 = to.split(",")).length) {
                throw new MpaasRuntimeException("%s.Lookup's from and to not correct", this.meta.getPojo());
            }
            sql.append("select ");
            for (int index = 0; index < s1.length; ++index) {
                if (index != 0) {
                    sql.append(",");
                }
                sql.append(s1[index]);
                sql.append(" ");
                sql.append(s2[index]);
                sql.append(" ");
            }
            sql.append(String.format(" from %s where %s", table, where));
        }
        return sql.toString();
    }

    private void validate(String from, String to, String table, String where) {
        if (from == null && to == null) {
            throw new MpaasRuntimeException("%s.Lookup must special from or to", this.meta.getPojo());
        }
        if (table == null) {
            throw new MpaasRuntimeException("%s.Lookup must special table", this.meta.getPojo());
        }
        if (where == null) {
            throw new MpaasRuntimeException("%s.Lookup must special where clause", this.meta.getPojo());
        }
    }

    private void executeSQL(String sql) {
        ArrayList<String> vars = new ArrayList<String>();
        Matcher m = VAR_PT.matcher(sql);
        while (m.find()) {
            vars.add(m.group(1));
        }
        for (String var : vars) {
            String p = String.format(this.adapter.varformat(), var);
            sql = sql.replaceAll("#" + var, p);
        }
        for (Object item : this.data) {
            this.handleItem(vars, sql, item);
        }
    }

    private void handleItem(List<String> vars, String sql, Object item) {
        ArrayList<Parameter> ps = new ArrayList<Parameter>();
        for (String var : vars) {
            PojoField f = this.meta.findPojoField(var);
            if (f == null) {
                throw new MpaasRuntimeException("pojo %s cant find field %s", this.meta.getPojo(), var);
            }
            Object v = f.getValue(item);
            if (v == null) {
                return;
            }
            ps.add(new Parameter(var, v));
        }
        String md5 = this.buildKeyMD5(sql, ps);
        Map row = (Map)lookupCache.get(md5, new CacheParam(this.adapter, sql, ps, this.currentLookup));
        this.assignValue(row, item);
    }

    private void assignValue(Map<String, Object> data, Object item) {
        if (data == null) {
            return;
        }
        for (String key : data.keySet()) {
            PojoField f = this.meta.findPojoField(key);
            if (f == null) continue;
            f.setValue(item, TypeUtil.convert(data.get(key), f.getField().getType()));
        }
    }

    private String buildKeyMD5(String sql, List<Parameter> params) {
        StringBuffer s = new StringBuffer();
        s.append(sql);
        s.append("#");
        for (Parameter p : params) {
            s.append(p.getName());
            s.append(":");
            s.append(p.getValue() == null ? "null" : p.getValue().toString());
            s.append("#");
        }
        return MD5Util.MD5Encode(s.toString());
    }

    public static void emptyCache() {
        lookupCache.emptyCache();
    }

    public static void clearCache(String key) {
        lookupCache.clearCache(key);
    }
}

