/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.security;

import com.definesys.mpaas.common.adapter.IMpaasSSOAuthentication;
import com.definesys.mpaas.common.adapter.UserProfile;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.session.MpaasSession;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityGate {
    private MpaasQueryConfig config;
    private IMpaasSSOAuthentication ssoAuthentication;

    public SecurityGate(MpaasQueryConfig config, IMpaasSSOAuthentication ssoAuthentication) {
        this.config = config;
        this.ssoAuthentication = ssoAuthentication;
    }

    public void unAuthorized(ServletResponse servletResponse) {
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        try {
            res.getOutputStream().write("{\"code\":\"error\",\"message\":\"Unauthorized\"}".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        res.setStatus(401);
    }

    public boolean auth(HttpServletRequest request, boolean ignore) {
        UserProfile userProfile;
        block4: {
            userProfile = UserProfile.anonymous;
            try {
                if (this.config.isCustomAuth() || this.ssoAuthentication != null) {
                    userProfile = this.customeAuth(request);
                }
                if (!this.config.isCustomAuth() && userProfile.isAnonymous()) {
                    userProfile = this.httpHeadAuth(request);
                }
            }
            catch (Throwable ex) {
                if (ignore) break block4;
                ex.printStackTrace();
            }
        }
        MpaasSession.setUserProfile(userProfile);
        return !userProfile.isAnonymous();
    }

    private UserProfile httpHeadAuth(HttpServletRequest request) {
        String uid = request.getHeader(this.config.userHeaderName);
        UserProfile userProfile = new UserProfile();
        userProfile.setAnonymous(false);
        if (uid == null || uid.trim().length() == 0) {
            uid = "anonymous";
            userProfile.setAnonymous(true);
        }
        userProfile.setUid(uid);
        userProfile.setUserName("\u533f\u540d\u7528\u6237");
        return userProfile;
    }

    private UserProfile customeAuth(HttpServletRequest request) {
        UserProfile userProfile = UserProfile.anonymous;
        if (this.ssoAuthentication != null) {
            userProfile = this.ssoAuthentication.ssoAuth(this.getHeaders(request), this.getCookies(request));
        }
        return userProfile;
    }

    private Map<String, String> getCookies(HttpServletRequest httpRequest) {
        Cookie[] cookies = httpRequest.getCookies();
        HashMap<String, String> ck = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie k : cookies) {
                ck.put(k.getName(), k.getValue());
            }
        }
        return ck;
    }

    private Map<String, String> getHeaders(HttpServletRequest httpRequest) {
        HashMap<String, String> header = new HashMap<String, String>();
        Enumeration headers = httpRequest.getHeaderNames();
        while (headers.hasMoreElements()) {
            String label = (String)headers.nextElement();
            header.put(label, httpRequest.getHeader(label));
        }
        return header;
    }

    public boolean validateURISecurity(String uri) {
        boolean bok = false;
        if (this.config.publicFilter != null && this.config.publicFilter.trim().length() > 0) {
            for (String f : this.config.publicFilter.split(",")) {
                if (!uri.matches(f) && !uri.endsWith(f)) continue;
                bok = true;
                break;
            }
        }
        return bok;
    }
}

