/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.query.util.Base32Util;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class MpaasQueryUtil {
    public static String upper2Underline(String name) {
        return name.replaceAll("(?<=[a-z])(?=[A-Z])", "_");
    }

    public static String encryptRowId(Object value, String secret) {
        if (value == null) {
            return null;
        }
        String s = MpaasQueryUtil.getValidSecret(secret);
        try {
            SecretKeySpec aesKey = new SecretKeySpec(s.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            byte[] encrypted = cipher.doFinal(value.toString().getBytes());
            return Base32Util.encode(encrypted);
        }
        catch (Exception e) {
            throw new MpaasRuntimeException(e);
        }
    }

    public static String decryptRowId(String value, String secret) {
        if (value == null) {
            return null;
        }
        String s = MpaasQueryUtil.getValidSecret(secret);
        SecretKeySpec aesKey = new SecretKeySpec(s.getBytes(), "AES");
        String decrypted = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            decrypted = new String(cipher.doFinal(Base32Util.decode(value)));
            return decrypted;
        }
        catch (Exception e) {
            decrypted = value;
            return decrypted;
        }
    }

    public static Date currentDate() {
        return Calendar.getInstance().getTime();
    }

    private static String getValidSecret(String value) {
        int size = value.length();
        if (size >= 32) {
            return value.substring(0, 32);
        }
        if (size >= 24) {
            return value.substring(0, 24);
        }
        if (size >= 16) {
            return value.substring(0, 16);
        }
        throw new MpaasRuntimeException("invalid secret:" + value + " secret length must large than 16");
    }
}

