/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.query.util;

import java.util.HashMap;

public class StringUtils {
    private static final HashMap<Character, String> htmlEncodeChars = new HashMap();

    private StringUtils() {
    }

    public static String encodeHtml(String source) {
        return StringUtils.encode(source, htmlEncodeChars);
    }

    private static String encode(String source, HashMap<Character, String> encodingTable) {
        if (null == source) {
            return null;
        }
        if (null == encodingTable) {
            return source;
        }
        StringBuffer encoded_string = null;
        char[] string_to_encode_array = source.toCharArray();
        int last_match = -1;
        int difference = 0;
        for (int i = 0; i < string_to_encode_array.length; ++i) {
            char char_to_encode = string_to_encode_array[i];
            if (!encodingTable.containsKey(Character.valueOf(char_to_encode))) continue;
            if (null == encoded_string) {
                encoded_string = new StringBuffer(source.length());
            }
            if ((difference = i - (last_match + 1)) > 0) {
                encoded_string.append(string_to_encode_array, last_match + 1, difference);
            }
            encoded_string.append(encodingTable.get(Character.valueOf(char_to_encode)));
            last_match = i;
        }
        if (null == encoded_string) {
            return source;
        }
        difference = string_to_encode_array.length - (last_match + 1);
        if (difference > 0) {
            encoded_string.append(string_to_encode_array, last_match + 1, difference);
        }
        return encoded_string.toString();
    }

    static {
        htmlEncodeChars.put(Character.valueOf('&'), "&amp;");
        htmlEncodeChars.put(Character.valueOf('<'), "&lt;");
        htmlEncodeChars.put(Character.valueOf('>'), "&gt;");
        htmlEncodeChars.put(Character.valueOf('\"'), "&quot;");
    }
}

