/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.sql2o.Connection;
import org.sql2o.GenericDatasource;
import org.sql2o.JndiDataSource;
import org.sql2o.Query;
import org.sql2o.Sql2oException;
import org.sql2o.StatementRunnable;
import org.sql2o.StatementRunnableWithResult;
import org.sql2o.connectionsources.ConnectionSource;
import org.sql2o.connectionsources.DataSourceConnectionSource;
import org.sql2o.logging.LocalLoggerFactory;
import org.sql2o.logging.Logger;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksDetector;

public class Sql2o {
    final Quirks quirks;
    private Map<String, String> defaultColumnMappings;
    private boolean defaultCaseSensitive;
    private ConnectionSource connectionSource;
    private static final Logger logger = LocalLoggerFactory.getLogger(Sql2o.class);

    public Sql2o(String jndiLookup) {
        this(JndiDataSource.getJndiDatasource(jndiLookup));
    }

    public Sql2o(String url, String user, String pass) {
        this(url, user, pass, QuirksDetector.forURL(url));
    }

    public Sql2o(String url, String user, String pass, Quirks quirks) {
        this(new GenericDatasource(url, user, pass), quirks);
    }

    public Sql2o(DataSource dataSource) {
        this(dataSource, QuirksDetector.forObject(dataSource));
    }

    public Sql2o(DataSource dataSource, Quirks quirks) {
        this.connectionSource = new DataSourceConnectionSource(dataSource);
        this.quirks = quirks;
        this.defaultColumnMappings = new HashMap<String, String>();
    }

    public Quirks getQuirks() {
        return this.quirks;
    }

    @Deprecated
    public DataSource getDataSource() {
        if (this.connectionSource instanceof DataSourceConnectionSource) {
            return ((DataSourceConnectionSource)this.connectionSource).getDataSource();
        }
        return null;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public Map<String, String> getDefaultColumnMappings() {
        return this.defaultColumnMappings;
    }

    public void setDefaultColumnMappings(Map<String, String> defaultColumnMappings) {
        this.defaultColumnMappings = defaultColumnMappings;
    }

    public boolean isDefaultCaseSensitive() {
        return this.defaultCaseSensitive;
    }

    public void setDefaultCaseSensitive(boolean defaultCaseSensitive) {
        this.defaultCaseSensitive = defaultCaseSensitive;
    }

    @Deprecated
    public Query createQuery(String query, boolean returnGeneratedKeys) {
        return new Connection(this, true).createQuery(query, returnGeneratedKeys);
    }

    @Deprecated
    public Query createQuery(String query) {
        Connection connection = new Connection(this, true);
        return connection.createQuery(query);
    }

    public Connection open(ConnectionSource connectionSource) {
        return new Connection(this, connectionSource, false);
    }

    public Connection open() {
        return new Connection(this, false);
    }

    public <V> V withConnection(StatementRunnableWithResult<V> runnable, Object argument) {
        try (Connection connection = null;){
            connection = this.open();
            V v = runnable.run(connection, argument);
            return v;
        }
    }

    public <V> V withConnection(StatementRunnableWithResult<V> runnable) {
        return this.withConnection(runnable, null);
    }

    public void withConnection(StatementRunnable runnable) {
        this.withConnection(runnable, null);
    }

    public void withConnection(StatementRunnable runnable, Object argument) {
        try (Connection connection = null;){
            connection = this.open();
            runnable.run(connection, argument);
        }
    }

    public Connection beginTransaction(int isolationLevel) {
        return this.beginTransaction(this.getConnectionSource(), isolationLevel);
    }

    public Connection beginTransaction(ConnectionSource connectionSource, int isolationLevel) {
        Connection connection = new Connection(this, connectionSource, false);
        boolean success = false;
        try {
            connection.getJdbcConnection().setAutoCommit(false);
            connection.getJdbcConnection().setTransactionIsolation(isolationLevel);
            success = true;
        }
        catch (SQLException e) {
            throw new Sql2oException("Could not start the transaction - " + e.getMessage(), e);
        }
        finally {
            if (!success) {
                connection.close();
            }
        }
        return connection;
    }

    public Connection beginTransaction() {
        return this.beginTransaction(2);
    }

    public Connection beginTransaction(ConnectionSource connectionSource) {
        return this.beginTransaction(connectionSource, 2);
    }

    public void runInTransaction(StatementRunnable runnable) {
        this.runInTransaction(runnable, null);
    }

    public void runInTransaction(StatementRunnable runnable, Object argument) {
        this.runInTransaction(runnable, argument, 2);
    }

    public void runInTransaction(StatementRunnable runnable, Object argument, int isolationLevel) {
        Connection connection = this.beginTransaction(isolationLevel);
        connection.setRollbackOnException(false);
        try {
            runnable.run(connection, argument);
        }
        catch (Throwable throwable) {
            connection.rollback();
            throw new Sql2oException("An error occurred while executing StatementRunnable. Transaction is rolled back.", throwable);
        }
        connection.commit();
    }

    public <V> V runInTransaction(StatementRunnableWithResult<V> runnableWithResult) {
        return this.runInTransaction(runnableWithResult, null);
    }

    public <V> V runInTransaction(StatementRunnableWithResult<V> runnableWithResult, Object argument) {
        return this.runInTransaction(runnableWithResult, argument, 2);
    }

    public <V> V runInTransaction(StatementRunnableWithResult<V> runnableWithResult, Object argument, int isolationLevel) {
        V result;
        Connection connection = this.beginTransaction(isolationLevel);
        try {
            result = runnableWithResult.run(connection, argument);
        }
        catch (Throwable throwable) {
            connection.rollback();
            throw new Sql2oException("An error occurred while executing StatementRunnableWithResult. Transaction rolled back.", throwable);
        }
        connection.commit();
        return result;
    }
}

