/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.logging;

import org.sql2o.logging.Logger;

public class SysOutLogger
implements Logger {
    public static Logger instance = new SysOutLogger();
    private static final long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String WARN_LVL = "WARN";

    @Override
    public void debug(String format, Object[] argArray) {
    }

    @Override
    public void debug(String format, Object arg) {
    }

    @Override
    public void warn(String format) {
        this.log(format, WARN_LVL, null);
    }

    @Override
    public void warn(String format, Throwable exception) {
        this.log(format, WARN_LVL, exception);
    }

    private void log(String msg, String level, Throwable exception) {
        StringBuilder buffer = new StringBuilder();
        long millis = System.currentTimeMillis();
        buffer.append(millis - startTime);
        buffer.append(" [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(level);
        buffer.append(" ");
        buffer.append(this.getClass().getName());
        buffer.append(" - ");
        buffer.append(msg);
        buffer.append(LINE_SEPARATOR);
        System.err.print(buffer.toString());
        if (exception != null) {
            exception.printStackTrace(System.err);
        }
        System.err.flush();
    }
}

