/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.build.MetaTable;
import com.dexcoder.dal.build.SqlBuilder;
import com.dexcoder.dal.handler.GenericTokenParser;
import com.dexcoder.dal.handler.NativeTokenHandler;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlBuilder
implements SqlBuilder {
    public static final String[] NATIVE_TOKENS = new String[]{"{", "}", "[", "]"};
    protected MetaTable metaTable;
    protected Set<GenericTokenParser> tokenParsers;

    public AbstractSqlBuilder(Class<?> clazz) {
        this.metaTable = new MetaTable.Builder().initAutoFields().tableClass(clazz).build();
    }

    @Override
    public MetaTable getMetaTable() {
        return this.metaTable;
    }

    protected Set<GenericTokenParser> initTokenParsers(MetaTable metaTable) {
        if (this.tokenParsers == null) {
            this.tokenParsers = new HashSet<GenericTokenParser>(2);
            NativeTokenHandler tokenHandler = new NativeTokenHandler(null);
            this.tokenParsers.add(new GenericTokenParser(NATIVE_TOKENS[0], NATIVE_TOKENS[1], tokenHandler));
            tokenHandler = new NativeTokenHandler(metaTable);
            this.tokenParsers.add(new GenericTokenParser(NATIVE_TOKENS[2], NATIVE_TOKENS[3], tokenHandler));
        }
        return this.tokenParsers;
    }

    protected String tokenParse(AutoField autoField, MetaTable metaTable) {
        String content = StrUtils.isBlank((String)autoField.getAnnotationName()) ? autoField.getName() : autoField.getAnnotationName();
        return this.tokenParse(content, metaTable);
    }

    protected String tokenParse(String content, MetaTable metaTable) {
        Set<GenericTokenParser> tokenParsers = this.initTokenParsers(metaTable);
        String result = content;
        for (GenericTokenParser tokenParser : tokenParsers) {
            result = tokenParser.parse(result);
        }
        return result;
    }
}

