/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.build.AutoFieldType;

public class AutoField {
    public static final String REGEX_NATIVE_FIELD = "(^[\\[].+[\\]]$)|(^[{].+[}]$)";
    private String name;
    private String annotationName;
    private String logicalOperator;
    private String fieldOperator;
    private Object value;
    private AutoFieldType type;

    public boolean isNativeField() {
        return this.name.matches(REGEX_NATIVE_FIELD);
    }

    public boolean isBracket() {
        return this.type == AutoFieldType.BRACKET_BEGIN || this.type == AutoFieldType.BRACKET_END;
    }

    public boolean isFieldOperatorNeedBracket() {
        return StrUtils.indexOf((String)StrUtils.upperCase((String)this.fieldOperator), (String)"IN") != -1;
    }

    public String getName() {
        return this.name;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public String getFieldOperator() {
        return this.fieldOperator;
    }

    public Object getValue() {
        return this.value;
    }

    public AutoFieldType getType() {
        return this.type;
    }

    public static class Builder {
        private AutoField autoField = new AutoField();

        public Builder name(String fieldName) {
            this.autoField.name = fieldName;
            return this;
        }

        public Builder logicalOperator(String logicalOperator) {
            this.autoField.logicalOperator = logicalOperator;
            return this;
        }

        public Builder fieldOperator(String fieldOperator) {
            this.autoField.fieldOperator = fieldOperator;
            return this;
        }

        public Builder value(Object value) {
            this.autoField.value = value;
            return this;
        }

        public Builder type(AutoFieldType type) {
            this.autoField.type = type;
            return this;
        }

        public Builder annotationName(String annotationName) {
            this.autoField.annotationName = annotationName;
            return this;
        }

        public AutoField build() {
            assert (this.autoField.name != null || this.autoField.annotationName != null);
            return this.autoField;
        }
    }
}

