/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.commons.utils.ClassUtils;
import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.annotation.Column;
import com.dexcoder.dal.annotation.Table;
import com.dexcoder.dal.annotation.Transient;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.build.AutoFieldType;
import com.dexcoder.dal.handler.MappingHandler;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTable {
    private String annotationTableName;
    private String tableAlias;
    private String pkColumnName;
    private Class<?> tableClass;
    private String pkFieldName;
    private MappingHandler mappingHandler;
    private List<AutoField> columnAutoFields;
    private Map<String, AutoField> autoFields;
    private List<String> includeFields;
    private List<String> excludeFields;
    private List<AutoField> funcAutoFields;
    private boolean isFieldExclusion = false;
    private boolean isOrderBy = true;

    private MetaTable() {
    }

    public List<String> getIncludeFields() {
        return this.includeFields;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public List<AutoField> getFuncAutoFields() {
        return this.funcAutoFields;
    }

    public String getPkColumnName() {
        if (StrUtils.isBlank((String)this.pkColumnName)) {
            this.pkColumnName = this.mappingHandler.getPkColumnName(this.tableClass);
        }
        return this.pkColumnName;
    }

    public String getPkFieldName() {
        if (StrUtils.isBlank((String)this.pkFieldName)) {
            this.pkFieldName = this.mappingHandler.getPkFieldName(this.tableClass);
        }
        return this.pkFieldName;
    }

    public String getPkFieldName(MappingHandler mappingHandler) {
        if (StrUtils.isBlank((String)this.pkFieldName)) {
            this.pkFieldName = mappingHandler.getPkFieldName(this.tableClass);
        }
        return this.pkFieldName;
    }

    public Class<?> getTableClass() {
        return this.tableClass;
    }

    public List<AutoField> getColumnAutoFields() {
        return this.columnAutoFields;
    }

    public boolean hasColumnFields() {
        return this.columnAutoFields != null && !this.columnAutoFields.isEmpty();
    }

    public boolean hasAutoFields() {
        return !this.autoFields.isEmpty();
    }

    public boolean hasAutoField(String fieldName) {
        return this.autoFields.get(fieldName) != null;
    }

    public Map<String, AutoField> getAutoFields() {
        return this.autoFields;
    }

    public String getColumnAndTableAliasName(AutoField autoField) {
        if (StrUtils.isBlank((String)autoField.getAnnotationName())) {
            return this.getColumnAndTableAliasName(autoField.getName());
        }
        if (StrUtils.isBlank((String)this.tableAlias)) {
            return autoField.getAnnotationName();
        }
        return this.tableAlias + "." + autoField.getAnnotationName();
    }

    public String getColumnAndTableAliasName(String fieldName) {
        String columnName;
        String string = columnName = StrUtils.equals((String)fieldName, (String)this.getPkFieldName()) ? this.getPkColumnName() : this.mappingHandler.getColumnName(this.tableClass, fieldName);
        if (StrUtils.isBlank((String)this.tableAlias)) {
            return columnName;
        }
        return this.tableAlias + "." + columnName;
    }

    public String applyColumnTableAlias(String columnName) {
        if (StrUtils.isBlank((String)this.tableAlias)) {
            return columnName;
        }
        return this.tableAlias + "." + columnName;
    }

    public String getTableAndAliasName() {
        String tableName = this.getTableName();
        if (StrUtils.isBlank((String)this.tableAlias)) {
            return tableName;
        }
        return tableName + " " + this.tableAlias;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public boolean hasFuncAutoField() {
        return this.funcAutoFields != null && !this.funcAutoFields.isEmpty();
    }

    public boolean isIncludeField(String fieldName) {
        if (this.includeFields == null || this.includeFields.isEmpty()) {
            return true;
        }
        return this.includeFields.contains(fieldName);
    }

    public boolean isExcludeField(String fieldName) {
        if (this.excludeFields == null || this.excludeFields.isEmpty()) {
            return false;
        }
        return this.excludeFields.contains(fieldName);
    }

    public String getTableName() {
        if (StrUtils.isNotBlank((String)this.annotationTableName)) {
            return this.annotationTableName;
        }
        return this.mappingHandler.getTableName(this.tableClass, this.autoFields);
    }

    public boolean isFieldExclusion() {
        return this.isFieldExclusion;
    }

    public boolean isOrderBy() {
        return this.isOrderBy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private MetaTable metaTable;

        public Builder() {
            this.metaTable = new MetaTable();
        }

        public Builder(MetaTable metaTable) {
            this.metaTable = metaTable;
        }

        public Builder initAutoFields() {
            this.metaTable.autoFields = new LinkedHashMap();
            return this;
        }

        public Builder initColumnAutoFields() {
            this.metaTable.columnAutoFields = new ArrayList();
            return this;
        }

        public Builder initIncludeFields() {
            this.metaTable.includeFields = new ArrayList();
            return this;
        }

        public Builder initExcludeFields() {
            this.metaTable.excludeFields = new ArrayList();
            return this;
        }

        public Builder initFuncAutoFields() {
            this.metaTable.funcAutoFields = new ArrayList();
            return this;
        }

        public Builder tableClass(Class<?> tableClass) {
            this.metaTable.tableClass = tableClass;
            Table aTable = tableClass.getAnnotation(Table.class);
            if (aTable != null) {
                this.metaTable.annotationTableName = aTable.name();
                this.metaTable.pkColumnName = aTable.pkColumn();
                this.metaTable.pkFieldName = aTable.pkField();
                if (StrUtils.isBlank((String)this.metaTable.tableAlias)) {
                    this.metaTable.tableAlias = aTable.alias();
                }
                if (!Object.class.equals(aTable.mappingHandler())) {
                    this.metaTable.mappingHandler = (MappingHandler)ClassUtils.newInstance(aTable.mappingHandler());
                }
            }
            return this;
        }

        public Builder tableAlias(String tableAlias) {
            this.metaTable.tableAlias = tableAlias;
            return this;
        }

        public Builder entity(Object entity, boolean isIgnoreNull) {
            PropertyDescriptor[] propertyDescriptors;
            if (entity == null) {
                return this;
            }
            BeanInfo selfBeanInfo = ClassUtils.getSelfBeanInfo(entity.getClass());
            for (PropertyDescriptor pd : propertyDescriptors = selfBeanInfo.getPropertyDescriptors()) {
                Object value;
                Transient aTransient;
                Method readMethod = pd.getReadMethod();
                if (readMethod == null || (aTransient = readMethod.getAnnotation(Transient.class)) != null) continue;
                String fieldName = pd.getName();
                String fieldAnnotationName = null;
                Column aColumn = readMethod.getAnnotation(Column.class);
                if (aColumn != null) {
                    fieldAnnotationName = aColumn.name();
                }
                if (this.metaTable.columnAutoFields != null) {
                    AutoField autoField = new AutoField.Builder().name(fieldName).annotationName(fieldAnnotationName).build();
                    this.metaTable.columnAutoFields.add(autoField);
                }
                if (this.metaTable.hasAutoField(fieldName) || (value = ClassUtils.invokeMethod((Method)readMethod, (Object)entity)) == null && isIgnoreNull) continue;
                AutoField autoField = new AutoField.Builder().name(fieldName).annotationName(fieldAnnotationName).logicalOperator("and").fieldOperator("=").type(AutoFieldType.NORMAL).value(value).build();
                this.metaTable.getAutoFields().put(fieldName, autoField);
            }
            return this;
        }

        public Builder isFieldExclusion(boolean isFieldExclusion) {
            this.metaTable.isFieldExclusion = isFieldExclusion;
            return this;
        }

        public Builder isOrderBy(boolean isOrderBy) {
            this.metaTable.isOrderBy = isOrderBy;
            return this;
        }

        public Builder mappingHandler(MappingHandler mappingHandler) {
            this.metaTable.mappingHandler = mappingHandler;
            return this;
        }

        public MetaTable build() {
            assert (this.metaTable.tableClass != null);
            return this.metaTable;
        }
    }
}

