/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.BoundSql;
import com.dexcoder.dal.build.AbstractSqlBuilder;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.build.AutoFieldType;
import com.dexcoder.dal.build.CriteriaBoundSql;
import com.dexcoder.dal.build.MetaTable;
import com.dexcoder.dal.build.SqlBuilder;
import com.dexcoder.dal.build.WhereBuilder;
import com.dexcoder.dal.handler.MappingHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateBuilder
extends AbstractSqlBuilder {
    protected static final String COMMAND_OPEN = "UPDATE ";
    private SqlBuilder whereBuilder;

    public UpdateBuilder(Class<?> clazz) {
        super(clazz);
        this.whereBuilder = new WhereBuilder(clazz);
    }

    @Override
    public void addField(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        AutoField autoField = new AutoField.Builder().name(fieldName).logicalOperator(logicalOperator).fieldOperator(fieldOperator).type(type).value(value).build();
        this.metaTable.getAutoFields().put(fieldName, autoField);
    }

    @Override
    public void addCondition(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        this.whereBuilder.addCondition(fieldName, logicalOperator, fieldOperator, type, value);
    }

    @Override
    public BoundSql build(Object entity, boolean isIgnoreNull, MappingHandler mappingHandler) {
        this.metaTable = new MetaTable.Builder(this.metaTable).entity(entity, isIgnoreNull).mappingHandler(mappingHandler).build();
        Iterator<Map.Entry<String, AutoField>> iterator = this.metaTable.getAutoFields().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, AutoField> entry = iterator.next();
            AutoField pkAutoField = entry.getValue();
            if (StrUtils.equals((String)this.metaTable.getPkFieldName(), (String)entry.getKey())) {
                iterator.remove();
                if (this.whereBuilder.getMetaTable().hasAutoField(entry.getKey())) continue;
                this.whereBuilder.addCondition(pkAutoField.getName(), pkAutoField.getLogicalOperator(), pkAutoField.getFieldOperator(), pkAutoField.getType(), pkAutoField.getValue());
                continue;
            }
            this.whereBuilder.addCondition(pkAutoField.getName(), pkAutoField.getLogicalOperator(), pkAutoField.getFieldOperator(), AutoFieldType.TRANSIENT, pkAutoField.getValue());
        }
        new MetaTable.Builder(this.whereBuilder.getMetaTable()).tableAlias(this.metaTable.getTableAlias()).mappingHandler(mappingHandler).build();
        StringBuilder sql = new StringBuilder(COMMAND_OPEN);
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.whereBuilder.getMetaTable().getTableAndAliasName()).append(" SET ");
        for (Map.Entry<String, AutoField> entry : this.metaTable.getAutoFields().entrySet()) {
            String columnName = this.metaTable.getColumnAndTableAliasName(entry.getValue());
            AutoField autoField = entry.getValue();
            if (autoField.isNativeField()) {
                String nativeFieldName = this.tokenParse(autoField.getName(), this.metaTable);
                String nativeValue = this.tokenParse(String.valueOf(autoField.getValue()), this.metaTable);
                sql.append(nativeFieldName).append(" = ").append(nativeValue).append(",");
                continue;
            }
            if (autoField.getValue() == null) {
                sql.append(columnName).append(" = NULL,");
                continue;
            }
            sql.append(columnName).append(" = ?,");
            params.add(autoField.getValue());
        }
        sql.deleteCharAt(sql.length() - 1);
        BoundSql boundSql = this.whereBuilder.build(entity, isIgnoreNull, mappingHandler);
        sql.append(boundSql.getSql());
        params.addAll(boundSql.getParameters());
        return new CriteriaBoundSql(sql.toString(), params);
    }
}

