/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.java;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.java.ImportOrderStep;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;

public class ImportOrder
implements FormatterStepFactory {
    @Parameter
    private String file;
    @Parameter
    private String order;
    @Parameter
    private boolean wildcardsLast = false;
    @Parameter
    private boolean semanticSort = false;
    @Parameter
    private Set<String> treatAsPackage = new HashSet<String>();
    @Parameter
    private Set<String> treatAsClass = new HashSet<String>();

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig config) {
        if (this.file != null ^ this.order != null) {
            if (this.file != null) {
                File importsFile = config.getFileLocator().locateFile(this.file);
                return ImportOrderStep.forJava().createFrom(this.wildcardsLast, this.semanticSort, this.treatAsPackage, this.treatAsClass, importsFile);
            }
            return ImportOrderStep.forJava().createFrom(this.wildcardsLast, this.semanticSort, this.treatAsPackage, this.treatAsClass, this.order.split(",", -1));
        }
        if (this.file == null && this.order == null) {
            return ImportOrderStep.forJava().createFrom(this.wildcardsLast, this.semanticSort, this.treatAsPackage, this.treatAsClass, new String[0]);
        }
        throw new IllegalArgumentException("Must specify exactly one of 'file' or 'order'.");
    }
}

