/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.api;

import com.dingtalk.open.app.api.ClientOption;
import com.dingtalk.open.app.api.DingTalkAppError;
import com.dingtalk.open.app.api.GenericEventListener;
import com.dingtalk.open.app.api.KeepAliveOption;
import com.dingtalk.open.app.api.OpenDingTalkAppException;
import com.dingtalk.open.app.api.OpenDingTalkClient;
import com.dingtalk.open.app.api.OpenDingTalkStreamClient;
import com.dingtalk.open.app.api.Preconditions;
import com.dingtalk.open.app.api.callback.CallbackCommandExecutor;
import com.dingtalk.open.app.api.callback.OpenDingTalkCallbackListener;
import com.dingtalk.open.app.api.command.CommandDispatcher;
import com.dingtalk.open.app.api.graph.GraphDispatcher;
import com.dingtalk.open.app.api.protocol.CommandExecutor;
import com.dingtalk.open.app.api.protocol.EventCommandExecutor;
import com.dingtalk.open.app.api.security.DingTalkCredential;
import com.dingtalk.open.app.api.util.ThreadUtil;
import com.dingtalk.open.app.stream.network.api.NetProxy;
import com.dingtalk.open.app.stream.network.core.Subscription;
import com.dingtalk.open.app.stream.protocol.CommandType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class OpenDingTalkStreamClientBuilder {
    private int consumeThreads = 16;
    private final Map<CommandType, CommandExecutor> commands = new HashMap<CommandType, CommandExecutor>();
    private final Set<Subscription> subscriptions = new HashSet<Subscription>();
    private DingTalkCredential credential;
    private int maxConnectionCount = 1;
    private int connectionTimeToLive = 21600000;
    private long connectTimeout = 3000L;
    private Proxy proxy;
    private KeepAliveOption keepAliveOption = new KeepAliveOption();
    private String openApiHost = "https://api.dingtalk.com";

    private OpenDingTalkStreamClientBuilder() {
    }

    public static OpenDingTalkStreamClientBuilder custom() {
        return new OpenDingTalkStreamClientBuilder();
    }

    public OpenDingTalkStreamClientBuilder consumeThreads(int threads) {
        this.consumeThreads = Preconditions.checkPositive(threads);
        return this;
    }

    public OpenDingTalkStreamClientBuilder registerAllEventListener(GenericEventListener listener) {
        Preconditions.notNull(listener);
        this.commands.put(CommandType.EVENT, new EventCommandExecutor(Preconditions.notNull(listener)));
        this.subscribe(CommandType.EVENT, "*");
        return this;
    }

    public OpenDingTalkStreamClientBuilder keepAlive(KeepAliveOption keepAliveOption) {
        this.keepAliveOption = Preconditions.notNull(keepAliveOption);
        return this;
    }

    public <Req, Resp> OpenDingTalkStreamClientBuilder registerCallbackListener(String topic, OpenDingTalkCallbackListener<Req, Resp> callbackListener) {
        Preconditions.notNull(topic);
        Preconditions.notNull(callbackListener);
        CallbackCommandExecutor executor = (CallbackCommandExecutor)this.commands.computeIfAbsent(CommandType.CALLBACK, key -> new CallbackCommandExecutor());
        executor.register(topic, callbackListener);
        this.subscribe(CommandType.CALLBACK, topic);
        return this;
    }

    public OpenDingTalkStreamClientBuilder maxConnectionCounts(int maxConnectionCount) {
        this.maxConnectionCount = Preconditions.checkPositive(maxConnectionCount);
        return this;
    }

    public OpenDingTalkStreamClientBuilder credential(DingTalkCredential credential) {
        this.credential = Preconditions.notNull(credential);
        return this;
    }

    @Deprecated
    public OpenDingTalkStreamClientBuilder timeout(int timeout) {
        this.connectTimeout = Preconditions.checkPositive(timeout);
        return this;
    }

    public OpenDingTalkStreamClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    private OpenDingTalkStreamClientBuilder openApiHost(String host) {
        this.openApiHost = Preconditions.notNull(host);
        return this;
    }

    public OpenDingTalkStreamClientBuilder preEnv() {
        return this.openApiHost("https://pre-api.dingtalk.com");
    }

    public OpenDingTalkStreamClientBuilder proxy(NetProxy netProxy) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(netProxy.getIp(), (int)netProxy.getPort()));
        return this;
    }

    public OpenDingTalkStreamClientBuilder forwardGraphRequestToHTTP(int port) {
        return this.registerCallbackListener("/v1.0/graph/api/invoke", new GraphDispatcher(port));
    }

    public OpenDingTalkClient build() {
        ClientOption option = new ClientOption();
        option.setConnectTimeout(this.connectTimeout);
        option.setMaxConnectionCount(this.maxConnectionCount);
        option.setConnectionTTL(this.connectionTimeToLive);
        option.setOpenApiHost(this.openApiHost);
        option.setKeepAliveOption(this.keepAliveOption);
        ExecutorService executor = ThreadUtil.newFixedExecutor(this.consumeThreads, "DingTalk-Consumer");
        return new OpenDingTalkStreamClient(this.credential, new CommandDispatcher(this.commands), executor, option, this.subscriptions, this.proxy);
    }

    private void subscribe(CommandType type, String topic) {
        if (!this.subscriptions.add(new Subscription(type, topic))) {
            throw new OpenDingTalkAppException(DingTalkAppError.DUPLICATE_TOPIC_ERROR, type.name(), topic);
        }
    }
}

