/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.reader;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.reader.FieldReaderObject;
import shade.com.alibaba.fastjson2.schema.JSONSchema;
import shade.com.alibaba.fastjson2.util.TypeUtils;

final class FieldReaderFloatValueMethod<T>
extends FieldReaderObject<T> {
    FieldReaderFloatValueMethod(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Float defaultValue, JSONSchema schema, Method setter) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, setter, null, null);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        float fieldValue = jsonReader.readFloatValue();
        if (this.schema != null) {
            this.schema.assertValidate((double)fieldValue);
        }
        try {
            this.method.invoke(object, Float.valueOf(fieldValue));
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        float fieldValue = jsonReader.readFloatValue();
        if (this.schema != null) {
            this.schema.assertValidate((double)fieldValue);
        }
        try {
            this.method.invoke(object, Float.valueOf(fieldValue));
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        float floatValue = TypeUtils.toFloatValue(value);
        if (this.schema != null) {
            this.schema.assertValidate((double)floatValue);
        }
        try {
            this.method.invoke(object, Float.valueOf(floatValue));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, int value) {
        if (this.schema != null) {
            this.schema.assertValidate((long)value);
        }
        try {
            this.method.invoke(object, Float.valueOf(value));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

