/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.function.Function;
import shade.com.alibaba.fastjson2.JSONB;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.util.Fnv;
import shade.com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;

final class ObjectWriterImplDoubleValueArray
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplDoubleValueArray INSTANCE = new ObjectWriterImplDoubleValueArray(null);
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[D");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[D");
    final DecimalFormat format;
    private final Function<Object, double[]> function;

    public ObjectWriterImplDoubleValueArray(DecimalFormat format) {
        this.format = format;
        this.function = null;
    }

    public ObjectWriterImplDoubleValueArray(Function<Object, double[]> function, DecimalFormat format) {
        this.function = function;
        this.format = format;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        double[] array = this.function != null && object != null ? this.function.apply(object) : (double[])object;
        jsonWriter.writeDouble(array);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        double[] array = this.function != null && object != null ? this.function.apply(object) : (double[])object;
        if (this.format == null) {
            jsonWriter.writeDouble(array);
        } else {
            jsonWriter.writeDouble(array, this.format);
        }
    }
}

