/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.conversion.msoffice.MicrosoftOfficeScript;
import com.documents4j.conversion.msoffice.MicrosoftWordBridge;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.MoreObjects;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum MicrosoftWordScript implements MicrosoftOfficeScript
{
    CONVERSION("/word_convert.vbs"),
    STARTUP("/word_start.vbs"),
    SHUTDOWN("/word_shutdown.vbs"),
    ASSERTION("/word_assert.vbs");

    private static final Logger LOGGER;
    private static final Random RANDOM;
    private final String path;

    private MicrosoftWordScript(String path) {
        this.path = path;
    }

    public String getName() {
        return this.path.substring(1);
    }

    public String getRandomizedName() {
        String name = this.getName();
        int extensionIndex = name.lastIndexOf(46);
        if (extensionIndex < 0) {
            return String.format("%s%d", name, RANDOM.nextInt());
        }
        return String.format("%s%d.%s", name.substring(0, extensionIndex), Math.abs(RANDOM.nextInt()), name.substring(extensionIndex + 1));
    }

    public File materializeIn(File folder) {
        File script = new File(folder, this.getRandomizedName());
        try {
            if (!script.createNewFile()) {
                throw new IOException(String.format("Could not create file %s", script));
            }
            String override = System.getProperty("com.documents4j.conversion.msoffice." + this.path.substring(1));
            if (override == null) {
                Resources.asByteSource((URL)Resources.getResource(((Object)((Object)this)).getClass(), (String)this.path)).copyTo(Files.asByteSink((File)script, (FileWriteMode[])new FileWriteMode[0]));
            } else {
                Files.asByteSource((File)new File(override)).copyTo(Files.asByteSink((File)script, (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        catch (IOException e) {
            String message = String.format("Could not copy script resource '%s' to local file system at '%s'", this.path, folder);
            LOGGER.error(message, (Throwable)e);
            throw new FileSystemInteractionException(message, (Throwable)e);
        }
        return script;
    }

    public String toString() {
        return MoreObjects.toStringHelper(MicrosoftWordScript.class).add("resource", (Object)this.path).toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(MicrosoftWordBridge.class);
        RANDOM = new Random();
    }
}

